/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncThreadFragmentTracer;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.IAsyncMetricProvider;
import com.wily.introscope.agent.async.IAsyncMetricUpdater;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;

public abstract class AsyncFrontendTracer
extends AsyncThreadFragmentTracer
implements IAsyncMetricProvider,
IAsyncMetricUpdater {
    public static final int kConcurrentMetricIndex = 0;
    public static final int kTimerMetricIndex = 1;
    public static final int kPerIntervalMetricIndex = 2;
    public static final int kStallMetricIndex = 3;
    public static final int kErrorMetricIndex = 4;

    public AsyncFrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public AsyncVirtualStack.AsyncComponentMetrics constructAsyncComponentMetrics(String componentName, String bizTrxName) {
        AsyncVirtualStack.AsyncComponentMetrics metrics = new AsyncVirtualStack.AsyncComponentMetrics();
        metrics.blameMetrics = this.constructAsyncComponentMetrics(componentName);
        if (bizTrxName != null) {
            metrics.btMetrics = this.constructAsyncComponentMetrics(bizTrxName);
        }
        return metrics;
    }

    private AsyncVirtualStack.AsyncMetricHolder[] constructAsyncComponentMetrics(String metricName) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        AsyncVirtualStack.AsyncMetricHolder[] metrics = new AsyncVirtualStack.AsyncMetricHolder[5];
        try {
            AgentMetric[] concurrentMetric = this.createFrontendConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(metricName));
            concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
            metrics[0] = new AsyncVirtualStack.AsyncMetricHolder(concurrentSds, concurrentMetric);
            AgentMetric[] timerMetric = this.createFrontendTimerMetric(this.getTimerMetricName(metricName));
            timerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
            metrics[1] = new AsyncVirtualStack.AsyncMetricHolder(timerSds, timerMetric);
            AgentMetric[] perIntervalMetric = this.createFrontendPerIntervalMetric(this.getPerIntervalMetricName(metricName));
            perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
            metrics[2] = new AsyncVirtualStack.AsyncMetricHolder(perIntervalSds, perIntervalMetric);
            AgentMetric[] stallMetric = this.createFrontendStallsMetric(this.getStallsMetricName(metricName));
            stallSds = this.getSharedRepositoryNoSharedStructure(false);
            metrics[3] = new AsyncVirtualStack.AsyncMetricHolder(stallSds, stallMetric);
            AgentMetric[] errorMetric = this.createFrontendErrorsMetric(this.getErrorsMetricName(metricName));
            errorsSds = this.getSharedRepositoryNoSharedStructure(false);
            metrics[4] = new AsyncVirtualStack.AsyncMetricHolder(errorsSds, errorMetric);
        }
        catch (TransactionTransitionException e) {
            for (AsyncVirtualStack.AsyncMetricHolder holder : metrics) {
                if (holder == null || holder.metric == null) continue;
                holder.metric[0].remove();
            }
            this.getModuleFeedback().warn(kModule, "Failed to create metric due to clamp for " + metricName);
            return null;
        }
        return metrics;
    }

    @Override
    public void updateAsyncComponentMetricsAtStart(AsyncVirtualStack.AsyncComponentMetrics metrics, long startTime) {
        if (metrics.blameMetrics != null) {
            this.updateAsyncComponentMetricsAtStart(metrics.blameMetrics, startTime);
        }
        if (metrics.btMetrics != null) {
            this.updateAsyncComponentMetricsAtStart(metrics.btMetrics, startTime);
        }
    }

    private void updateAsyncComponentMetricsAtStart(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.increase(startTime);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtStall(AsyncVirtualStack.AsyncComponentMetrics metrics, long time) {
        if (metrics.blameMetrics != null) {
            this.updateAsyncComponentMetricsAtStall(metrics.blameMetrics, time);
        }
        if (metrics.btMetrics != null) {
            this.updateAsyncComponentMetricsAtStall(metrics.btMetrics, time);
        }
    }

    private void updateAsyncComponentMetricsAtStall(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[3];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtError(AsyncVirtualStack.AsyncComponentMetrics metrics, long time) {
        if (metrics.blameMetrics != null) {
            this.updateAsyncComponentMetricsAtError(metrics.blameMetrics, time);
        }
        if (metrics.btMetrics != null) {
            this.updateAsyncComponentMetricsAtError(metrics.btMetrics, time);
        }
    }

    private void updateAsyncComponentMetricsAtError(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[4];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtAbort(AsyncVirtualStack.AsyncComponentMetrics metrics, long time, boolean didStall) {
        if (metrics.blameMetrics != null) {
            this.updateAsyncComponentMetricsAtAbort(metrics.blameMetrics, time, didStall);
        }
        if (metrics.btMetrics != null) {
            this.updateAsyncComponentMetricsAtAbort(metrics.btMetrics, time, didStall);
        }
    }

    private void updateAsyncComponentMetricsAtAbort(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time, boolean didStall) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.decrease(time);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtEnd(AsyncVirtualStack.AsyncComponentMetrics metrics, long startTime, long endTime, boolean didStall) {
        if (metrics.blameMetrics != null) {
            this.updateAsyncComponentMetricsAtEnd(metrics.blameMetrics, startTime, endTime, didStall);
        }
        if (metrics.btMetrics != null) {
            this.updateAsyncComponentMetricsAtEnd(metrics.btMetrics, startTime, endTime, didStall);
        }
    }

    private void updateAsyncComponentMetricsAtEnd(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime, long endTime, boolean didStall) {
        IRepository rep;
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        long elapsed = endTime - startTime;
        if (cin != null) {
            cin.decrease(endTime);
        }
        if ((rep = metrics[1].sds) != null) {
            rep.update((IUpdater)updater, elapsed, endTime, 0);
        }
        if ((rep = metrics[2].sds) != null) {
            rep.update(increaser, 0L, endTime, 0);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(endTime);
        }
    }
}

