/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backendprotocols;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.event.IEventNoticer;
import com.wily.introscope.agent.trace.backend.http.tracer.ManagedHttpURLStreamHandler;
import com.wily.introscope.agent.trace.backend.http.tracer.ManagedHttpsURLStreamHandler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import sun.net.www.protocol.https.Handler;

public class BackendsObjectNoticer
implements IEventNoticer {
    private final Module module = new Module("BackendsObjectNoticer");
    private final IModuleFeedbackChannel feedback;
    private final Field factoryField;
    private final Field handlersField;
    private final Field handlerField;
    private final Hashtable<String, URLStreamHandler> handlers;
    private boolean handlerFactorySetInUrl = false;
    private boolean httpHandlerFixed = false;
    private boolean httpsHandlerFixed = false;

    public BackendsObjectNoticer(IAgent agent) throws Exception {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.factoryField = URL.class.getDeclaredField("factory");
        this.factoryField.setAccessible(true);
        this.handlersField = URL.class.getDeclaredField("handlers");
        this.handlersField.setAccessible(true);
        this.handlers = (Hashtable)this.handlersField.get(null);
        this.handlerField = URL.class.getDeclaredField("handler");
        this.handlerField.setAccessible(true);
    }

    public void IEventNoticer_noticeEvent(String probeClassName, String probeMethodName, String probeMethodDescriptor, String eventType, Object eventSpecificReference, String eventSpecificData, String eventSpecificData2) {
        if (this.handlerFactorySetInUrl && this.httpHandlerFixed && this.httpsHandlerFixed) {
            return;
        }
        if (eventType == "Object_Created" && eventSpecificReference instanceof URL) {
            URL url = (URL)eventSpecificReference;
            String protocol = url.getProtocol();
            if (this.httpHandlerFixed && "http".equals(protocol)) {
                return;
            }
            if (this.httpsHandlerFixed && "https".equals(protocol)) {
                return;
            }
            if ("http".equals(protocol) || "https".equals(protocol)) {
                this.feedback.debug(this.module, "Recevied event: " + eventType + ", reference=" + eventSpecificReference);
                try {
                    sun.net.www.protocol.http.Handler managedHandler;
                    sun.net.www.protocol.http.Handler managedHandler2;
                    URLStreamHandler handlerInTable = this.handlers.get(protocol);
                    if (handlerInTable instanceof ManagedHttpURLStreamHandler || handlerInTable instanceof ManagedHttpsURLStreamHandler) {
                        return;
                    }
                    URLStreamHandlerFactory factory = (URLStreamHandlerFactory)this.factoryField.get(null);
                    if (factory != null) {
                        this.feedback.debug(this.module, "URLStreamHandlerFactory has been set.");
                        this.handlerFactorySetInUrl = true;
                    }
                    if ("http".equals(protocol) && handlerInTable instanceof sun.net.www.protocol.http.Handler) {
                        this.feedback.debug(this.module, "Setting ManagedHttpURLStreamHandler in URL handler table for http protocol.");
                        managedHandler2 = new ManagedHttpURLStreamHandler(handlerInTable, this.feedback);
                        this.handlers.put("http", managedHandler2);
                        this.httpHandlerFixed = true;
                    } else if ("https".equals(protocol) && handlerInTable instanceof Handler) {
                        this.feedback.debug(this.module, "Setting ManagedHttpsURLStreamHandler in URL handler table for https protocol.");
                        managedHandler2 = new ManagedHttpsURLStreamHandler(handlerInTable, this.feedback);
                        this.handlers.put("https", managedHandler2);
                        this.httpsHandlerFixed = true;
                    } else {
                        if (("http".equals(protocol) || "https".equals(protocol)) && this.feedback.isDebugEnabled(this.module)) {
                            this.feedback.debug(this.module, protocol + " has unknown handler " + handlerInTable.getClass().getCanonicalName());
                        }
                        return;
                    }
                    URLStreamHandler handler = (URLStreamHandler)this.handlerField.get(url);
                    if (handler instanceof ManagedHttpURLStreamHandler || handler instanceof ManagedHttpsURLStreamHandler) {
                        return;
                    }
                    if ("http".equals(protocol) && handler instanceof sun.net.www.protocol.http.Handler) {
                        managedHandler = new ManagedHttpURLStreamHandler(handler, this.feedback);
                        this.handlerField.set(url, managedHandler);
                    }
                    if ("https".equals(protocol) && handler instanceof Handler) {
                        managedHandler = new ManagedHttpsURLStreamHandler(handler, this.feedback);
                        this.handlerField.set(url, managedHandler);
                    }
                }
                catch (SecurityException e) {
                    this.feedback.debug(this.module, "Failed to set ManagedHttpURLStreamHandler for URL", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.feedback.debug(this.module, "Failed to set ManagedHttpURLStreamHandler for URL", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.feedback.debug(this.module, "Failed to set ManagedHttpURLStreamHandler for URL", (Throwable)e);
                }
            }
        }
    }
}

