/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.frontend.jms;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.frontend.jms.JMSReceiveFrontendTransactionElement;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Collections;
import java.util.Map;

public class JMSReceiveSharedTracerHelper
extends BlamePointTracer
implements BackendProtocolsConstants {
    private static final Module ModuleName = new Module("JMSReceiveSharedTracerHelper");
    private static ThreadLocal<JMSReceiveTxnCache> jmsReceiveTxnCache = new ThreadLocal<JMSReceiveTxnCache>(){

        @Override
        protected JMSReceiveTxnCache initialValue() {
            return new JMSReceiveTxnCache();
        }
    };

    public static boolean isParentAlreadyInstrumented(InvocationData data) {
        JMSReceiveTxnCache cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
        return cache.isParentTracerAvailable;
    }

    public static void setParentInstrumented(InvocationData data, boolean isParentInstrumented) {
        JMSReceiveTxnCache cache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
        cache.isParentTracerAvailable = isParentInstrumented;
    }

    public JMSReceiveSharedTracerHelper(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected WilyTransactionElement constructTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, ProbeInformation probeInformation) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        IRepository estimatedTimerSds = null;
        Map metrics = Collections.EMPTY_MAP;
        WilyTransactionStructure structure = this.getWilyTransactionStructureInstance();
        AgentMetric[] estimatedTimerMetric = this.createTimerMetric(this.getMessageProcessingTimeMetricName(componentName));
        estimatedTimerSds = this.getSharedRepository((ISharedElement)AverageMetricGathererWrapper.getFactory((boolean)true), this.fNumberOfStripes);
        estimatedTimerSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(estimatedTimerMetric), (IRepository)estimatedTimerSds);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getMessageReceivedPerIntervalMetricName(componentName));
        perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
        perIntervalSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(perIntervalMetric), (IRepository)perIntervalSds);
        AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(componentName));
        errorsSds = this.getSharedRepository(true, this.fNumberOfStripes);
        errorsSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(errorMetric), (IRepository)errorsSds);
        JMSReceiveFrontendTransactionElement result = new JMSReceiveFrontendTransactionElement(key, componentName, this.getBlameStatus(), isStartTrace, parent, previous, start, metrics, timerSds, estimatedTimerSds, perIntervalSds, concurrentSds, errorsSds, stallSds, probeInformation, this.subscribeToDownstreamErrors(), false, this.getFilterEnablerBit());
        return result;
    }

    public void updateTheCustomMetricInStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        long lastReceivedTime = -1L;
        lastReceivedTime = JMSReceiveSharedTracerHelper.jmsReceiveTxnCache.get().lastReceiveTimeInThisThread;
        if (lastReceivedTime != -1L) {
            long elapsed = elementData.getWallClockStartTime() - lastReceivedTime;
            JMSReceiveFrontendTransactionElement jmsTxnElement = (JMSReceiveFrontendTransactionElement)element;
            IRepository rep = jmsTxnElement.getEstimatedTimeRepository();
            if (rep != null) {
                rep.update(JMSReceiveSharedTracerHelper.getUpdater(), elapsed, lastReceivedTime, elementData.hashCode());
            }
        }
    }

    private String getMessageReceivedPerIntervalMetricName(String componentName) {
        return componentName + ":Messages Received Per Interval";
    }

    private String getMessageProcessingTimeMetricName(String componentName) {
        return componentName + ":Estimated Message Processing Time (ms)";
    }

    public static JMSReceiveTxnCache getJMSReceiveTxnCache(InvocationData data) {
        if (data == null) {
            return jmsReceiveTxnCache.get();
        }
        JMSReceiveTxnCache cache = (JMSReceiveTxnCache)data.get("jms.transactioncache.key");
        if (cache == null) {
            cache = jmsReceiveTxnCache.get();
            data.put("jms.transactioncache.key", (Object)cache);
        }
        return cache;
    }

    public static void clearJMSReceiveTxnCache(InvocationData data) {
        JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data).clear();
    }

    public static void finishTxnTraceForReceive(InvocationData data, boolean parentCalled) {
        JMSReceiveTxnCache jmsReceiveCache = JMSReceiveSharedTracerHelper.getJMSReceiveTxnCache(data);
        if (jmsReceiveCache.data != null) {
            boolean isFirst = false;
            Object destination = JMSHelper.getConsumerDestination(data);
            if (destination != null) {
                isFirst = destination.equals(jmsReceiveCache.firstDestination);
            } else {
                Object consumer = data.getInvocationObject();
                boolean bl = isFirst = consumer == jmsReceiveCache.firstConsumer;
            }
            if (parentCalled || isFirst) {
                String didSyntheticTxnTraceStart = (String)jmsReceiveCache.data.get("jms.synthetic.tracer.run.key");
                if (didSyntheticTxnTraceStart == null) {
                    return;
                }
                jmsReceiveCache.data.IMethodTracer_setReentrancyOverwrite(true);
                jmsReceiveCache.data.getWallClockFinishTime();
                jmsReceiveCache.data.IMethodTracer_finishTrace();
                jmsReceiveCache.data = null;
                jmsReceiveCache.firstDestination = null;
                jmsReceiveCache.incomingCorId = null;
                JMSHelper.debug(ModuleName, "Finished the Receive Txn Trace. " + Thread.currentThread());
            }
        }
    }

    public static void finishTxnTraceForReceive(InvocationData data) {
        JMSReceiveSharedTracerHelper.finishTxnTraceForReceive(data, false);
    }

    public static class JMSReceiveTxnCache {
        InvocationData data;
        int tracerIndex;
        long lastReceiveTimeInThisThread;
        IRepository estimatedTimeRepo;
        IRepository aggregatedEstimatedTimeRepo;
        boolean isParentTracerAvailable;
        Object firstDestination;
        Object firstConsumer;
        public String incomingCorId;

        public JMSReceiveTxnCache() {
            this.init();
        }

        private void init() {
            this.data = null;
            this.tracerIndex = -1;
            this.lastReceiveTimeInThisThread = -1L;
            this.estimatedTimeRepo = null;
            this.aggregatedEstimatedTimeRepo = null;
            this.isParentTracerAvailable = false;
            this.firstDestination = null;
            this.firstConsumer = null;
            this.incomingCorId = null;
        }

        public void clear() {
            this.init();
        }
    }
}

