/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CommonUtils {
    private static final int MIN_DOMAIN_LEVEL = 2;

    public static String findPackage(String className) {
        int index = className.lastIndexOf(".");
        String packageName = index <= -1 ? "" : className.substring(0, index);
        return packageName;
    }

    public static boolean validatePackage(String packageNameRegex) {
        String[] labels = packageNameRegex.split("\\.");
        int qualifiedLabels = 0;
        if (labels.length > 0) {
            for (String label : labels) {
                if (label.trim().length() <= 0) continue;
                ++qualifiedLabels;
            }
        }
        return qualifiedLabels > 0;
    }

    public static boolean validateAppDomainPackage(String packageNameRegex) {
        boolean status = false;
        if (CommonUtils.validatePackage(packageNameRegex)) {
            String[] splits = packageNameRegex.split("\\.");
            status = splits.length > 2;
        }
        return status;
    }

    public static String findApplicationDomain(IndexAwareTraceElement traceElement) {
        String className = traceElement.getClassName();
        String[] splits = className.split("\\.");
        if (splits.length > 2) {
            return splits[0] + "." + splits[1];
        }
        return "";
    }

    public static String convertToPackageRegex(String packageName) {
        return packageName.replace(".", "\\.") + ".*";
    }

    public static Set<String> convertToPackageRegexSet(Set<String> packages) {
        LinkedHashSet<String> regexSet = new LinkedHashSet<String>();
        for (String pkg : packages) {
            regexSet.add(CommonUtils.convertToPackageRegex(pkg));
        }
        return regexSet;
    }

    public static boolean doesElementPackageMatch(IndexAwareTraceElement traceElement, Set<Pattern> pkgPatterns) {
        String pkg = traceElement.getPackageName();
        return CommonUtils.doesPackgeMatchesPatterns(pkg, pkgPatterns);
    }

    public static boolean doesElementPackageMatch(StackTraceElement traceElement, Set<Pattern> pkgPatterns) {
        String pkg = CommonUtils.findPackage(traceElement.getClassName());
        return CommonUtils.doesPackgeMatchesPatterns(pkg, pkgPatterns);
    }

    private static boolean doesPackgeMatchesPatterns(String pkg, Set<Pattern> pkgPatterns) {
        boolean matches = false;
        for (Pattern packagePattern : pkgPatterns) {
            if (!packagePattern.matcher(pkg).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    public static String getFqMethodName(String fqClassName, String methodName) {
        return fqClassName + "." + methodName;
    }

    public static String getTraceSignature(StackTraceElement[] trace) {
        StackTraceElement lastElement = trace[trace.length - 1];
        return lastElement.getClassName() + lastElement.getMethodName() + trace.length;
    }

    public static int getTraceHashCode(StackTraceElement[] trace) {
        StackTraceElement element = trace[trace.length - 1];
        int result = element.hashCode();
        element = trace[trace.length / 2];
        result = result + element.hashCode() + trace.length;
        return result;
    }

    public static String getStringRepresentationOfTrace(StackTraceElement[] traceElements) {
        StringBuilder buffer = new StringBuilder();
        for (StackTraceElement element : traceElements) {
            buffer.append(element.toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String getStringRepresentationOfTrace(IndexAwareTraceElement[] traceElements) {
        StringBuilder buffer = new StringBuilder();
        for (IndexAwareTraceElement element : traceElements) {
            buffer.append(element.getStackTraceElement().toString());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static String formatStringRep(String representation) {
        return "{" + representation + "}";
    }

    public static StackTraceElement sanitizetraceElement(StackTraceElement element) {
        try {
            if (element.getClassName().contains("/")) {
                element = new StackTraceElement(element.getClassName().substring(element.getClassName().indexOf("/") + 1), element.getMethodName(), element.getFileName(), element.getLineNumber());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return element;
    }
}

