/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public final class OverThresholdPerIntervalCounter
extends ASingleMetricTracerFactory {
    private final int fThresholdInMillis = this.getIntegerParameter("threshold", -1);

    public OverThresholdPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        Assertion.wilyAssert(false);
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.storeWallClockStartTime();
        this.addToBlameStackIfEnabled(data);
    }

    @Override
    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ILongIntervalCounterDataAccumulator count;
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        if (data.getWallClockElapsedTimeAsInt() > this.fThresholdInMillis && !(count = (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(data)).IDataAccumulator_isShutOff()) {
            count.ILongIntervalCounterDataAccumulator_addSingleIncident(snapshot);
        }
    }
}

