/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.ANameConverter;
import com.wily.introscope.agent.jmx.AbstractCustomHandler;
import com.wily.introscope.agent.jmx.AllSortedKeysNameConverter;
import com.wily.introscope.agent.jmx.DataViewFactory;
import com.wily.introscope.agent.jmx.Filter;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IJMXDataView;
import com.wily.introscope.agent.jmx.IMBeanNameConverter;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptorMBean;
import com.wily.introscope.agent.jmx.JMXClamp;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.jmx.JSR77NameConverter;
import com.wily.introscope.agent.jmx.ListCustomHandler;
import com.wily.introscope.agent.jmx.MBeanInterpreterJMXDataView;
import com.wily.introscope.agent.jmx.MBeanInterpreterJSR77;
import com.wily.introscope.agent.jmx.PrimaryKeysNameConverter;
import com.wily.introscope.agent.jmx.SpringBootEndpointDataView;
import com.wily.introscope.agent.jmx.SpringbootData;
import com.wily.introscope.agent.jmx.StandardMBeanServerLocator;
import com.wily.introscope.agent.jmx.WebLogicMBeanServerLocator;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.task.IExecutableItem;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.MonitorNotification;
import javax.management.relation.RelationNotification;
import javax.management.timer.TimerNotification;
import javax.security.auth.Subject;

public final class IntroscopeProtocolAdaptor
implements IntroscopeProtocolAdaptorMBean {
    public static final Module sModule = new Module("JMXService");
    private static final Map<String, AbstractCustomHandler> CUSTOM_OPERATIONS = new HashMap<String, AbstractCustomHandler>(){
        {
            ListCustomHandler handler = new ListCustomHandler("listEndpoints", "isPaused", "endPoint");
            this.put("ServerEndpointControl", handler);
        }
    };
    public static final String kProtocolAdaptorDomain = "com.wily.introscope.agent";
    public static final String kProtocolAdaptorNameKey = "name";
    public static final String kProtocolAdaptorNameValue = "IntroscopeProtocolAdaptor";
    public static boolean kNoSubStringMatch = false;
    private static final String kExcludeStringMetricsPropKey = "introscope.agent.jmx.excludeStringMetrics";
    private static final String kJmxSpringBootThreads = "introscope.agent.jmx.springboot.threads";
    private static final String kJmxSpringBootThreadsFilterChars = "introscope.agent.jmx.springboot.threads.filter.characters";
    public static MBeanInterpreterJSR77 interpreterJSR77 = new MBeanInterpreterJSR77();
    public static final String kRateCounterExtension = "_rate (per interval)";
    private static final String kDescription = "Introscope JMX Agent Protocol Adaptor";
    private static final String kJMXBehaviorName = "Introscope JMX Protocol Adaptor";
    private static final String kMBeanServerDelegateName = "JMImplementation:type=MBeanServerDelegate";
    private static IAgent fAgent;
    private ObjectName fDelegateObjectName;
    private IMBeanNameConverter fPrimaryNameConverter;
    private IMBeanNameConverter fSecondaryNameConverter;
    private IMBeanServerLocator[] fServerLocators;
    private Filter[] fFilters;
    private Filter[] fRateCounterFilters;
    private HashSet fIgnoreAttributes;
    private HashMap fViewsHashMap;
    private HashMap fEmptyViewsHashMap;
    private HashSet fServersHashSet;
    private final IntroscopeNotificationListener fNotificationListener;
    private final IntroscopeProtocolAdaptorHeartbeatBehavior fBehavior;
    private final ClassLoader fContextClassLoader;
    private IJMXCustomizer fJMXCustomizer = null;
    private Object fSubject;
    private final FindServersAndPollViewsAction fFindServersAndPollViewsAction;
    private AccessControlContext fAccessControlContext;
    private boolean allowLegacyJSR77 = false;
    private boolean fExcludeStringMetrics;
    private String fSecurityClassName;
    private String fPrivelegedMethodName;
    private Method fPrivelegedMethod;
    private static final String kSyncWithAllMbeanServersForcibly = "com.wily.introcope.agent.jmx.syncWithAllMbeanServersForcibly";
    private static boolean fSyncWithAllMbeanServersForcibly;
    private static boolean fCanRunForcedDiscovery;
    private static long fLastTime;
    public static List<String> fJmxSpringbootThreadsFilterCharList;
    public static List<String> fJmxSpringbootThreadsList;
    private JMXClamp clamp;
    private static volatile IntroscopeProtocolAdaptor instance;
    boolean fForceDebugToInfo = false;

    public static synchronized IntroscopeProtocolAdaptor createInstance(IAgent agent, IJMXCustomizer customizer, Object shouldBeSubject, String securityClassName, String privelegedMethodName, AccessControlContext acc) {
        if (instance == null) {
            instance = new IntroscopeProtocolAdaptor(agent, customizer, shouldBeSubject, securityClassName, privelegedMethodName, acc);
            return instance;
        }
        instance.setAccessParameters(customizer, shouldBeSubject, securityClassName, privelegedMethodName, acc);
        return null;
    }

    public static IntroscopeProtocolAdaptor getInstance() {
        return instance;
    }

    public IntroscopeProtocolAdaptor(IAgent agent) {
        this(agent, null);
    }

    public IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer) {
        this(agent, customizer, null, null, null, null);
    }

    private void setAccessParameters(IJMXCustomizer customizer, Object shouldBeSubject, String securityClassName, String privelegedMethodName, AccessControlContext acc) {
        if (this.fSubject != null && shouldBeSubject == null) {
            fAgent.IAgent_getModuleFeedback().info(sModule, "Do not override privileged/customized access");
            return;
        }
        this.fJMXCustomizer = customizer;
        this.fSubject = (Subject)shouldBeSubject;
        this.fSecurityClassName = securityClassName;
        this.fPrivelegedMethodName = privelegedMethodName;
        this.fAccessControlContext = acc;
        this.fServerLocators = this.fJMXCustomizer != null ? this.fJMXCustomizer.getMBeanServerLocators(fAgent) : new IMBeanServerLocator[]{new WebLogicMBeanServerLocator(fAgent), new StandardMBeanServerLocator()};
        fAgent.IAgent_getModuleFeedback().debug(sModule, "setAccessParameters: fSubject=" + this.fSubject + ", fSecurityClassName=" + this.fSecurityClassName + ", fPrivelegedMethodName=" + this.fPrivelegedMethodName + ", fAccessControlContext=" + this.fAccessControlContext + ", fJMXCustomizer=" + this.fJMXCustomizer + ", fServerLocators=" + this.fServerLocators);
    }

    private IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer, Object shouldBeSubject, String securityClassName, String privelegedMethodName, AccessControlContext acc) {
        fAgent = agent;
        this.fNotificationListener = new IntroscopeNotificationListener();
        this.setAccessParameters(customizer, shouldBeSubject, securityClassName, privelegedMethodName, acc);
        try {
            this.fDelegateObjectName = new ObjectName(kMBeanServerDelegateName);
        }
        catch (MalformedObjectNameException shouldNeverHappen) {
            Assertion.wilyAssert((boolean)false);
        }
        this.parseConfigProperties(agent.IAgent_getIndexedProperties());
        Assertion.wilyAssert((boolean)false);
        Assertion.wilyAssert((boolean)false);
        Assertion.wilyAssert((boolean)false);
        Assertion.wilyAssert((boolean)false);
        this.fViewsHashMap = new HashMap();
        this.fEmptyViewsHashMap = new HashMap();
        this.fServersHashSet = new HashSet();
        try {
            fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new MBeanForcedPollingEnabledProperty(fAgent), false);
        }
        catch (Exception shouldNeverHappen) {
            // empty catch block
        }
        this.fBehavior = new IntroscopeProtocolAdaptorHeartbeatBehavior();
        this.fContextClassLoader = this.getClass().getClassLoader();
        this.fFindServersAndPollViewsAction = new FindServersAndPollViewsAction();
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        String jmxSpringbootThreads = fAgent.IAgent_getIndexedProperties().getProperty(kJmxSpringBootThreads);
        if (jmxSpringbootThreads != null) {
            fJmxSpringbootThreadsList = Arrays.asList(jmxSpringbootThreads.split(","));
        }
        fJmxSpringbootThreadsFilterCharList = new ArrayList<String>();
        fJmxSpringbootThreadsFilterCharList.add("#");
        fJmxSpringbootThreadsFilterCharList.add("|");
        fJmxSpringbootThreadsFilterCharList.add(":");
        String jmxThreadFilterCharsProp = fAgent.IAgent_getIndexedProperties().getProperty(kJmxSpringBootThreadsFilterChars);
        if (jmxThreadFilterCharsProp != null) {
            fJmxSpringbootThreadsFilterCharList.addAll(Arrays.asList(jmxThreadFilterCharsProp.split(",")));
        }
        MBeanForcedDiscoveryControllingService mbeanForcedDiscoveryControllingBehavior = new MBeanForcedDiscoveryControllingService();
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)mbeanForcedDiscoveryControllingBehavior, "MBean Forced Discovery Controlling Behaviour", true, 300000L, false);
        this.clamp = JMXClamp.getInstance(fAgent);
    }

    private void parseConfigProperties(IndexedProperties props) {
        int i;
        String[] defaultVal;
        String[] filterKeys = defaultVal = new String[0];
        String[] rateCounterFilterKeys = defaultVal;
        this.fIgnoreAttributes = new HashSet();
        String[] primaryKeys = defaultVal;
        String filterMessage = "";
        String primaryKeysMessage = "";
        boolean useJsr77Formatter = false;
        IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
        if (props != null) {
            useJsr77Formatter = !props.getBooleanProperty("introscope.agent.jmx.name.jsr77.disable", true);
            this.allowLegacyJSR77 = props.getBooleanProperty("introscope.agent.jmx.name.jsr77.legacy.enable", true);
            MBeanInterpreterJSR77.setEnabled(useJsr77Formatter);
            String[] ignoreAttributes = props.safeGetSeparatedProperty("introscope.agent.jmx.ignore.attributes", ",", defaultVal);
            for (int i2 = 0; i2 < ignoreAttributes.length; ++i2) {
                this.fIgnoreAttributes.add(ignoreAttributes[i2]);
                feedback.trace(sModule, "Ignoring MBean attribute: " + ignoreAttributes[i2]);
            }
            filterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.filter", ",", defaultVal);
            rateCounterFilterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.ratecounter.name.filter", ",", defaultVal);
            primaryKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.primarykeys", ",", defaultVal);
            kNoSubStringMatch = props.getBooleanProperty("introscope.agent.jmx.filter.nosubstringmatch", false);
            primaryKeysMessage = props.getTrimmedProperty("introscope.agent.jmx.name.primarykeys", "");
            filterMessage = props.getTrimmedProperty("introscope.agent.jmx.name.filter", "");
            fSyncWithAllMbeanServersForcibly = props.getBooleanProperty(kSyncWithAllMbeanServersForcibly);
        }
        if (this.fJMXCustomizer != null) {
            filterKeys = this.fJMXCustomizer.modifyFilters(fAgent, filterKeys);
            rateCounterFilterKeys = this.fJMXCustomizer.modifyFilters(fAgent, rateCounterFilterKeys);
        }
        this.fFilters = new Filter[filterKeys.length];
        for (i = 0; i < filterKeys.length; ++i) {
            this.fFilters[i] = new Filter(filterKeys[i]);
        }
        this.fRateCounterFilters = new Filter[rateCounterFilterKeys.length];
        for (i = 0; i < rateCounterFilterKeys.length; ++i) {
            this.fRateCounterFilters[i] = new Filter(rateCounterFilterKeys[i]);
        }
        if (useJsr77Formatter) {
            this.fPrimaryNameConverter = new JSR77NameConverter(primaryKeys);
        } else {
            this.fPrimaryNameConverter = new PrimaryKeysNameConverter(primaryKeys);
            String localizedPrimaryKeysMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Primary_Keys_Info_Message", primaryKeysMessage);
            feedback.info(localizedPrimaryKeysMessage);
        }
        this.fSecondaryNameConverter = new AllSortedKeysNameConverter();
        String localizedFilterMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Filter_Info_Message", filterMessage);
        feedback.info(localizedFilterMessage);
    }

    void registerHeartbeatBehavior(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert((boolean)false);
        if (JMXDelegatingService.sIsJMXMaxPollDurationEnabled) {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 15000L, false);
        } else {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 7500L, false);
        }
    }

    @Override
    public String getDescription() {
        return kDescription;
    }

    public static String getIntroscopeProtocolAdaptorDomain() {
        return kProtocolAdaptorDomain;
    }

    public static ObjectName getIntroscopeProtocolAdaptorMBeanName() {
        try {
            return new ObjectName(kProtocolAdaptorDomain, kProtocolAdaptorNameKey, kProtocolAdaptorNameValue);
        }
        catch (MalformedObjectNameException shouldNotHappen) {
            Assertion.wilyAssert((boolean)false, (String)"Protocol Adaptor name is malformed");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContextAndPoll() {
        boolean isDebugEnabled;
        boolean allowForced;
        long startTime;
        block12: {
            startTime = System.currentTimeMillis();
            allowForced = fCanRunForcedDiscovery;
            isDebugEnabled = this.isTraceEnabled(sModule);
            if (isDebugEnabled) {
                this.trace(sModule, "DIAG: setContextAndPoll entry called - fCanRunForcedDiscovery = " + allowForced + ", fAccessControlContext=" + this.fAccessControlContext + ", fSubject=" + this.fSubject);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader savedContext = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.fContextClassLoader);
                if (this.fAccessControlContext != null) {
                    AccessController.doPrivileged(this.fFindServersAndPollViewsAction, this.fAccessControlContext);
                    break block12;
                }
                if (this.fSubject == null) {
                    this.findServersAndPollViews();
                    break block12;
                }
                try {
                    String subjectClassName = "javax.security.auth.Subject";
                    Class<?> subjectClass = null;
                    subjectClass = Class.forName("javax.security.auth.Subject");
                    if (subjectClass.isInstance(this.fSubject)) {
                        if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                            this.trace(sModule, "Found Subject = " + this.fSubject);
                            Class<?> securityClass = Class.forName(this.fSecurityClassName);
                            if (this.fPrivelegedMethod == null) {
                                this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                            }
                            this.fPrivelegedMethod.invoke(null, this.fSubject, this.fFindServersAndPollViewsAction);
                        }
                        break block12;
                    }
                    fAgent.IAgent_getModuleFeedback().error(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
                catch (Throwable t) {
                    fAgent.IAgent_getModuleFeedback().trace(sModule, "Unable to determine credentials, caught Throwable: ", t);
                }
            }
            finally {
                currentThread.setContextClassLoader(savedContext);
            }
        }
        long endTime = System.currentTimeMillis();
        if (isDebugEnabled) {
            this.trace(sModule, "DIAG: setContextAndPoll exit called - fCanRunForcedDiscovery = " + allowForced + "(" + (endTime - startTime) + " uS)");
        }
    }

    private synchronized void findServersAndPollViews() {
        boolean canWeForce = fCanRunForcedDiscovery;
        boolean isDebugEnabled = this.isTraceEnabled(sModule);
        try {
            for (int locatorIndex = 0; locatorIndex < this.fServerLocators.length; ++locatorIndex) {
                int serversLength;
                MBeanServer[] servers = this.fServerLocators[locatorIndex].IMBeanServerLocator_locate();
                int n = serversLength = servers != null ? servers.length : 0;
                if (serversLength <= 0) continue;
                long startTime = 0L;
                long endTime = 0L;
                if (isDebugEnabled) {
                    startTime = System.currentTimeMillis();
                }
                this.findAndAddMBeans(servers);
                if (!isDebugEnabled) continue;
                endTime = System.currentTimeMillis();
                this.trace(sModule, "DIAG: findAndAddMBeans for '" + serversLength + "' servers took " + (endTime - startTime) + " uS");
            }
            long s2 = 0L;
            long e2 = 0L;
            if (isDebugEnabled) {
                s2 = System.currentTimeMillis();
            }
            this.pollViews();
            if (isDebugEnabled) {
                e2 = System.currentTimeMillis();
                this.trace(sModule, "DIAG: pollViews took " + (e2 - s2) + " uS");
            }
            if (canWeForce) {
                this.DumpViewsStats();
            }
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().error("An error occurred polling JMX data.");
            fAgent.IAgent_getModuleFeedback().verbose((Throwable)e);
        }
    }

    private void DumpViewsStats() {
        if (this.isTraceEnabled(sModule)) {
            Iterator objectNameItr = this.fViewsHashMap.keySet().iterator();
            this.trace(sModule, "DIAG: Dump of JMX View ================================================================================");
            while (objectNameItr.hasNext()) {
                Object objName = objectNameItr.next();
                this.trace(sModule, "DIAG: JMX Object Name [" + objName.toString() + "]");
                Set viewsHash = (Set)this.fViewsHashMap.get(objName);
                for (IJMXDataView view : viewsHash) {
                    this.trace(sModule, "DIAG: JMX View: Average:" + view.getAveragePollTime() + " uS, Counts (" + view.getSuccessfulPollCount() + "/" + view.getPollCount() + ") Repeats (" + view.getRepeatedValuePollCount() + ") Name: '" + view.getFullMetricName() + "'");
                }
            }
            this.trace(sModule, "DIAG: End dump of JMX View ================================================================================");
        }
    }

    private void findAndAddMBeans(MBeanServer[] servers) {
        if (servers.length == 0) {
            return;
        }
        boolean isDebugEnabled = this.isTraceEnabled(sModule);
        int addedBeans = 0;
        for (int serverII = 0; serverII < servers.length; ++serverII) {
            long endTime;
            Set<Object> objectNames;
            MBeanServer currentServer;
            block17: {
                currentServer = servers[serverII];
                boolean newServer = false;
                if (!this.fServersHashSet.contains(currentServer)) {
                    this.fServersHashSet.add(currentServer);
                    try {
                        currentServer.addNotificationListener(this.fDelegateObjectName, this.fNotificationListener, null, (Object)currentServer);
                        newServer = true;
                        if (isDebugEnabled) {
                            this.trace(sModule, "DIAG: add new server to list " + currentServer);
                        }
                    }
                    catch (InstanceNotFoundException shouldNotHappen) {
                        Assertion.wilyAssert((boolean)false);
                    }
                }
                if (!newServer && (!fSyncWithAllMbeanServersForcibly || !fCanRunForcedDiscovery)) continue;
                fCanRunForcedDiscovery = false;
                objectNames = new HashSet();
                try {
                    if (isDebugEnabled) {
                        this.trace(sModule, "DIAG: query start " + currentServer.toString());
                    }
                    long startTime = 0L;
                    endTime = 0L;
                    if (isDebugEnabled) {
                        startTime = System.currentTimeMillis();
                    }
                    objectNames = currentServer.queryNames(null, null);
                    if (isDebugEnabled) {
                        endTime = System.currentTimeMillis();
                        this.trace(sModule, "DIAG: queryNames took " + (endTime - startTime) + " uS");
                    }
                    if (isDebugEnabled) {
                        this.trace(sModule, "DIAG: query  end  " + currentServer.toString() + " returned " + objectNames.size() + " object names");
                    }
                }
                catch (Exception e) {
                    if (!isDebugEnabled) break block17;
                    this.trace(sModule, "Error querying the m bean server" + currentServer, e);
                }
            }
            try {
                long startTime = 0L;
                endTime = 0L;
                if (isDebugEnabled) {
                    startTime = System.currentTimeMillis();
                }
                Iterator iterator = objectNames.iterator();
                while (iterator.hasNext()) {
                    if (!this.addMBean((ObjectName)iterator.next(), currentServer)) continue;
                    ++addedBeans;
                }
                if (!isDebugEnabled) continue;
                endTime = System.currentTimeMillis();
                this.trace(sModule, "DIAG: addMBean(s) took " + (endTime - startTime) + " uS");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isDebugEnabled) {
            this.trace(sModule, "DIAG: addedBeans = " + addedBeans);
        }
    }

    private void pollViews() {
        long accumulatedFailTime = 0L;
        long accumulatedExceptionTime = 0L;
        long longestTime = 0L;
        long shortestTime = 0L;
        String longestName = null;
        String shortestName = null;
        int totalIterations = 0;
        int totalObjectsIterated = 0;
        int transientFailures = 0;
        int exceptionFailures = 0;
        int objectNameRemovals = 0;
        int pollSkips = 0;
        int totalViews = 0;
        boolean isDebugEnabled = this.isDebugEnabled(sModule);
        boolean isTraceEnabled = this.isTraceEnabled(sModule);
        Iterator objectNameItr = this.fViewsHashMap.keySet().iterator();
        while (objectNameItr.hasNext()) {
            Object objName = objectNameItr.next();
            Set viewsHash = (Set)this.fViewsHashMap.get(objName);
            Iterator iterator = viewsHash.iterator();
            if (isTraceEnabled) {
                fAgent.IAgent_getModuleFeedback().trace(sModule, "DIAG: viewsHash " + objName.toString() + " has " + viewsHash.size());
            }
            ++totalObjectsIterated;
            if (isDebugEnabled && objName instanceof ObjectName) {
                totalViews += this.getNumberOfViewsForMBean((ObjectName)objName);
            }
            while (iterator.hasNext()) {
                long timeTaken;
                ++totalIterations;
                IJMXDataView view = (IJMXDataView)iterator.next();
                try {
                    boolean didWork = view.IJMXDataView_update();
                    timeTaken = view.getLastPollTime();
                    if (timeTaken > longestTime) {
                        longestTime = timeTaken;
                        longestName = view.getFullMetricName();
                    }
                    if (timeTaken < shortestTime || shortestTime == 0L) {
                        shortestTime = timeTaken;
                        shortestName = view.getFullMetricName();
                    }
                    if (!didWork) {
                        if (isDebugEnabled) {
                            this.debug(sModule, "JMX data unavailable for '" + view.getFullMetricName() + "', this may be a transient failure");
                            this.debug(sModule, "DIAG: Total poll count: " + view.getPollCount() + " SuccessfulPollCount: " + view.getSuccessfulPollCount() + " and took " + timeTaken + " uS");
                            accumulatedFailTime += timeTaken;
                        }
                        view.IJMXDataView_clear();
                        ++transientFailures;
                        continue;
                    }
                    if (isTraceEnabled) {
                        fAgent.IAgent_getModuleFeedback().trace(sModule, "JMX data available for '" + view.getFullMetricName());
                    }
                    if (!view.wasLastPollSkipped()) continue;
                    ++pollSkips;
                }
                catch (Throwable t) {
                    timeTaken = view.getLastPollTime();
                    accumulatedExceptionTime += timeTaken;
                    if (timeTaken > longestTime) {
                        longestTime = timeTaken;
                        longestName = view.getFullMetricName();
                    }
                    if (timeTaken < shortestTime || shortestTime == 0L) {
                        shortestTime = timeTaken;
                        shortestName = view.getFullMetricName();
                    }
                    if (isTraceEnabled) {
                        this.trace(sModule, "Error getting MBean info, this may be a transient failure '" + view.getFullMetricName() + "' " + t.toString());
                        this.trace(sModule, view.getFullMetricName(), t);
                    }
                    view.IJMXDataView_destroy();
                    iterator.remove();
                    ++exceptionFailures;
                }
            }
            if (!viewsHash.isEmpty()) continue;
            if (isTraceEnabled) {
                this.trace(sModule, "DIAG: clear for '" + objName.toString() + "'");
            }
            objectNameItr.remove();
            ++objectNameRemovals;
        }
        if (isTraceEnabled) {
            this.trace(sModule, "DIAG: total viewsHash = " + totalViews);
            this.trace(sModule, "DIAG: longest poll = " + longestTime + " uS " + longestName);
            this.trace(sModule, "DIAG: shortest poll = " + shortestTime + " uS " + shortestName);
            this.trace(sModule, "DIAG: total poll time for transient fails = " + accumulatedFailTime + " uS");
            this.trace(sModule, "DIAG: total poll time for exception fails = " + accumulatedExceptionTime + " uS");
            this.trace(sModule, "DIAG: total object iterations = " + totalObjectsIterated);
            this.trace(sModule, "DIAG: total view iterations = " + totalIterations);
            this.trace(sModule, "DIAG: transientFailures = " + transientFailures);
            this.trace(sModule, "DIAG: exceptionFailures = " + exceptionFailures);
            this.trace(sModule, "DIAG: objectNameRemovals = " + objectNameRemovals);
            this.trace(sModule, "DIAG: pollSkips = " + pollSkips);
        }
    }

    private void addMBean2(ObjectName objectName, MBeanServer server) {
        if (this.fAccessControlContext != null) {
            AccessController.doPrivileged(new AddMBeanAction(objectName, server), this.fAccessControlContext);
        } else if (this.fSubject == null) {
            this.addMBean(objectName, server);
        } else {
            try {
                String subjectClassName = "javax.security.auth.Subject";
                Class<?> subjectClass = null;
                subjectClass = Class.forName("javax.security.auth.Subject");
                if (subjectClass.isInstance(this.fSubject)) {
                    if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + this.fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                        }
                        this.fPrivelegedMethod.invoke(null, this.fSubject, new AddMBeanAction(objectName, server));
                        this.trace(sModule, "Successfully invoked javax.security.auth.Subject.doAs(subject, AddMBeanAction)");
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
            }
            catch (Throwable t) {
                fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
            }
        }
    }

    private void removeMBean2(ObjectName objectName, MBeanServer server) {
        if (this.fAccessControlContext != null) {
            AccessController.doPrivileged(new RemoveMBeanAction(objectName, server), this.fAccessControlContext);
        } else if (this.fSubject == null) {
            this.removeMBean(objectName, server);
        } else {
            try {
                String subjectClassName = "javax.security.auth.Subject";
                Class<?> subjectClass = null;
                subjectClass = Class.forName("javax.security.auth.Subject");
                if (subjectClass.isInstance(this.fSubject)) {
                    if (this.fSecurityClassName != null && this.fPrivelegedMethodName != null) {
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + this.fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, subjectClass, PrivilegedAction.class);
                        }
                        this.fPrivelegedMethod.invoke(null, this.fSubject, new RemoveMBeanAction(objectName, server));
                        this.trace(sModule, "Successfully invoked javax.security.auth.Subject.doAs(subject, RemoveMBeanAction)");
                    }
                } else {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
            }
            catch (Throwable t) {
                fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
            }
        }
    }

    private synchronized boolean addMBean(ObjectName objectName, MBeanServer server) {
        MBeanNotificationInfo[] notificationList;
        if (objectName.getCanonicalName().startsWith("org.springframework.boot")) {
            return this.addSpringBootMBean(objectName, server);
        }
        boolean isTraceEnabled = this.isTraceEnabled(sModule);
        String domain = objectName.getDomain();
        if (domain != null && IntroscopeProtocolAdaptor.getIntroscopeProtocolAdaptorDomain().equals(domain)) {
            return false;
        }
        if (objectName.isPattern()) {
            return false;
        }
        if (objectName.equals(this.fDelegateObjectName)) {
            return false;
        }
        if (this.haveAlreadySeenObjectName(objectName)) {
            return false;
        }
        if (this.haveAlreadySeenObjectNameWithEmptyViews(objectName)) {
            return false;
        }
        if (isTraceEnabled) {
            this.trace(sModule, "DIAG: adding '" + objectName.toString() + "'");
        }
        String resourceName = this.getIntroscopeResourceName(objectName);
        MBeanInfo beanInfo = null;
        try {
            beanInfo = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            if (isTraceEnabled) {
                this.trace(sModule, "Error getting MBeanInfo", e);
            }
            return false;
        }
        if (beanInfo == null) {
            if (isTraceEnabled) {
                this.trace(sModule, "DIAG: no bean info for '" + objectName.toString());
            }
            return false;
        }
        MBeanAttributeInfo[] attInfo = beanInfo.getAttributes();
        if (attInfo == null) {
            if (isTraceEnabled) {
                this.trace(sModule, "DIAG: no bean attributes for '" + objectName.toString());
            }
            return false;
        }
        if (isTraceEnabled && (notificationList = beanInfo.getNotifications()) != null) {
            for (int nl = 0; nl < notificationList.length; ++nl) {
                this.trace(sModule, "DIAG: notification info for '" + objectName.toString() + "' has " + notificationList[nl].toString());
            }
        }
        HashSet<AJMXDataView> viewsSet = new HashSet<AJMXDataView>();
        for (int attributeII = 0; attributeII < attInfo.length; ++attributeII) {
            MBeanAttributeInfo attrib = attInfo[attributeII];
            if (attrib == null || !attrib.isReadable()) {
                if (!isTraceEnabled) continue;
                this.trace(sModule, "DIAG: IntroscopeProtocolAdaptor.addMBean() skipping a null attribute entry at " + attributeII);
                continue;
            }
            String attName = attrib.getName();
            String attType = attrib.getType();
            if (attName == null || attType == null) {
                if (!isTraceEnabled) continue;
                this.trace(sModule, "DIAG: attribute name or type was null " + attName + " : " + attType);
                continue;
            }
            StringBuffer tmpName = new StringBuffer(resourceName);
            tmpName.append(':');
            tmpName.append(attName);
            ANameConverter.replaceTrailingWhitespace(tmpName);
            String fullIntroscopeMetricName = tmpName.toString();
            boolean bShouldPollMetric = this.shouldPollMetric(fullIntroscopeMetricName, attName);
            boolean bShouldPollRateCounterMetric = false;
            bShouldPollRateCounterMetric = this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName);
            if (!bShouldPollMetric && !bShouldPollRateCounterMetric) continue;
            try {
                boolean isLegacyJSR77;
                if (interpreterJSR77.isAvailable() && interpreterJSR77.isQualified(attType)) {
                    int colonPos = fullIntroscopeMetricName.lastIndexOf(":");
                    String rootIntroscopeMetricName = colonPos < 0 ? fullIntroscopeMetricName : fullIntroscopeMetricName.substring(0, colonPos);
                    MBeanInterpreterJMXDataView view = null;
                    if (this.haveAlreadySeenObjectName(objectName)) continue;
                    if (bShouldPollMetric) {
                        if (!this.clamp.isClampHit()) {
                            this.clamp.incrementMetricCounter();
                            view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName, interpreterJSR77, false, null);
                        } else {
                            this.clamp.printClampWarning();
                        }
                        if (view != null) {
                            if (isTraceEnabled) {
                                this.trace(sModule, "DIAG: new polled MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                            }
                            viewsSet.add(view);
                        }
                    }
                    if (!bShouldPollRateCounterMetric) continue;
                    rootIntroscopeMetricName = rootIntroscopeMetricName + kRateCounterExtension;
                    if (!this.clamp.isClampHit()) {
                        this.clamp.incrementMetricCounter();
                        view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName, interpreterJSR77, true, null);
                    } else {
                        this.clamp.printClampWarning();
                    }
                    if (view == null) continue;
                    if (isTraceEnabled) {
                        this.trace(sModule, "DIAG: new rate counter MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                    }
                    viewsSet.add(view);
                    continue;
                }
                boolean bl = isLegacyJSR77 = fullIntroscopeMetricName.indexOf("|JSR77|") >= 0;
                if (!this.allowLegacyJSR77 && isLegacyJSR77) continue;
                AJMXDataView view = null;
                if (this.haveAlreadySeenObjectName(objectName)) continue;
                try {
                    if (bShouldPollMetric && (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName, this.fExcludeStringMetrics, false)) != null) {
                        if (isTraceEnabled) {
                            this.trace(sModule, "DIAG: new legacy polled view (" + attType + ") " + fullIntroscopeMetricName);
                        }
                        viewsSet.add(view);
                        this.checkForCustomOperations(objectName, server, viewsSet, fullIntroscopeMetricName);
                    }
                    if (!bShouldPollRateCounterMetric || (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName = fullIntroscopeMetricName + kRateCounterExtension, this.fExcludeStringMetrics, true)) == null) continue;
                    if (isTraceEnabled) {
                        this.trace(sModule, "DIAG: new legacy rate counter polled view (" + attType + ") " + fullIntroscopeMetricName);
                    }
                    viewsSet.add(view);
                }
                catch (AccumulatorAlreadyExistsException ae) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, ae.getLocalizedMessage());
                }
                continue;
            }
            catch (Exception e) {
                IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
                String message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Could_Not_Create_View_Message", fullIntroscopeMetricName, objectName.toString() + " " + attName + " " + attType);
                fAgent.IAgent_safeReportError(message, (Throwable)e);
            }
        }
        if (viewsSet.size() == 0) {
            if (isTraceEnabled) {
                this.trace(sModule, "DIAG: adding empty viewsSet for:" + objectName);
            }
            this.addEmptyView(objectName);
            return false;
        }
        return this.addViews(objectName, viewsSet);
    }

    private void checkForCustomOperations(ObjectName objectName, MBeanServer server, Set viewsSet, String fullIntroscopeMetricName) {
        String value = objectName.getKeyProperty(kProtocolAdaptorNameKey);
        if (value != null && CUSTOM_OPERATIONS.containsKey(value)) {
            AbstractCustomHandler handler = CUSTOM_OPERATIONS.get(value);
            try {
                if (this.isTraceEnabled(sModule)) {
                    this.trace(sModule, "DIAG: found handler for " + value);
                }
                handler.handle(fAgent, objectName, server, viewsSet, fullIntroscopeMetricName);
            }
            catch (Exception e) {
                this.trace(sModule, e.getLocalizedMessage());
            }
        }
    }

    private boolean shouldPollMetric(String metricName, String attName) {
        Assertion.wilyAssert((boolean)false);
        Assertion.wilyAssert((boolean)false);
        if (this.fIgnoreAttributes.contains(attName)) {
            return false;
        }
        if (this.fFilters.length == 0) {
            return true;
        }
        for (int i = 0; i < this.fFilters.length; ++i) {
            Filter filter = this.fFilters[i];
            if (!filter.matches(metricName)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldPollMetric(String jmxFilter) {
        Assertion.wilyAssert((boolean)false);
        Assertion.wilyAssert((boolean)false);
        if (this.fFilters.length == 0) {
            return true;
        }
        for (int i = 0; i < this.fFilters.length; ++i) {
            Filter filter = this.fFilters[i];
            if (!filter.matches(jmxFilter)) continue;
            return true;
        }
        return false;
    }

    synchronized boolean addSpringBootMBean(ObjectName objectName, MBeanServer server) {
        if (!this.shouldPollMetric(objectName.getCanonicalName())) {
            return false;
        }
        if (objectName.getCanonicalName().contains("metricsEndpoint") || objectName.getCanonicalName().contains("dumpEndpoint")) {
            MBeanNotificationInfo[] notificationList;
            boolean isTraceEnabled = this.isTraceEnabled(sModule);
            HashSet<IJMXDataView> totalViewsSet = new HashSet<IJMXDataView>();
            String domain = objectName.getDomain();
            if (domain != null && IntroscopeProtocolAdaptor.getIntroscopeProtocolAdaptorDomain().equals(domain)) {
                return false;
            }
            if (objectName.isPattern()) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: Springboot metrics not processed - object name is a pattern");
                }
                return false;
            }
            if (objectName.equals(this.fDelegateObjectName)) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: Springboot metrics not processed - object name is a delegate");
                }
                return false;
            }
            if (this.haveAlreadySeenObjectName(objectName)) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: Springboot metrics not processed - object name is already seen");
                }
                return false;
            }
            if (this.haveAlreadySeenObjectNameWithEmptyViews(objectName)) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: Springboot metrics not processed - object name is already seen with empty views");
                }
                return false;
            }
            if (isTraceEnabled) {
                this.trace(sModule, "DIAG: adding '" + objectName.toString() + "'");
            }
            String resourceName = this.getIntroscopeResourceName(objectName);
            MBeanInfo beanInfo = null;
            try {
                beanInfo = server.getMBeanInfo(objectName);
            }
            catch (Exception e) {
                if (isTraceEnabled) {
                    this.trace(sModule, "Error getting MBeanInfo", e);
                }
                return false;
            }
            if (beanInfo == null) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: no bean info for '" + objectName.toString());
                }
                return false;
            }
            MBeanAttributeInfo[] attInfo = beanInfo.getAttributes();
            if (attInfo == null) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: no bean attributes for '" + objectName.toString());
                }
                return false;
            }
            if (isTraceEnabled && (notificationList = beanInfo.getNotifications()) != null) {
                for (int nl = 0; nl < notificationList.length; ++nl) {
                    this.trace(sModule, "DIAG: notification info for '" + objectName.toString() + "' has " + notificationList[nl].toString());
                }
            }
            for (int attributeII = 0; attributeII < attInfo.length; ++attributeII) {
                MBeanAttributeInfo attrib = attInfo[attributeII];
                if (attrib == null || !attrib.isReadable()) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: IntroscopeProtocolAdaptor.addSpringBootMBean() skipping a null attribute entry at " + attributeII);
                    continue;
                }
                String attName = attrib.getName();
                String attType = attrib.getType();
                try {
                    SpringBootEndpointDataView view;
                    Object attValue = server.getAttribute(objectName, attName);
                    if (isTraceEnabled) {
                        this.trace(sModule, "DIAG: Processing Attribute - " + attValue.toString());
                    }
                    HashMap viewsMap = new HashMap();
                    if (attValue instanceof ArrayList) {
                        viewsMap = this.parseSpringBootDumpEndpointData(objectName, server, isTraceEnabled, totalViewsSet, resourceName, attName, attType, attValue);
                        if (viewsMap.isEmpty() || (view = new SpringBootEndpointDataView(fAgent, objectName, server, attName, viewsMap)) == null) continue;
                        totalViewsSet.add(view);
                        if (!isTraceEnabled) continue;
                        this.trace(sModule, "DIAG: adding spring boot endpoint viewsSet for:" + objectName);
                        continue;
                    }
                    if (attValue instanceof LinkedHashMap) {
                        viewsMap = this.parseSpringBootMetricsEndpointData(objectName, server, isTraceEnabled, resourceName, attName, attType, attValue);
                        if (viewsMap.isEmpty() || (view = new SpringBootEndpointDataView(fAgent, objectName, server, attName, viewsMap)) == null) continue;
                        totalViewsSet.add(view);
                        if (!isTraceEnabled) continue;
                        this.trace(sModule, "DIAG: adding spring boot endpoint viewsSet for:" + objectName);
                        continue;
                    }
                    if (!(attValue instanceof String) && !(attValue instanceof Boolean)) continue;
                    SpringbootData dataObj = SpringbootData.getSpringbootDataObject(attValue.toString());
                    String customAttType = dataObj != null ? dataObj.getDataType() : attType;
                    String customMetricName = dataObj != null ? dataObj.getPrettyName() : ":" + attName;
                    IJMXDataView view2 = this.createSpringBootView(objectName, server, attName, attValue.toString(), customAttType, resourceName + customMetricName);
                    if (view2 == null) continue;
                    totalViewsSet.add(view2);
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: Creating view for - " + resourceName + customMetricName);
                    continue;
                }
                catch (JsonParseException e) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: Parse exception while creating view - " + objectName + " - " + attName);
                    continue;
                }
                catch (AttributeNotFoundException e1) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: AttributeNotFoundException", e1);
                    continue;
                }
                catch (InstanceNotFoundException e1) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: InstanceNotFoundException", e1);
                    continue;
                }
                catch (MBeanException e1) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: MBeanException", e1);
                    continue;
                }
                catch (ReflectionException e1) {
                    if (!isTraceEnabled) continue;
                    this.trace(sModule, "DIAG: ReflectionException", e1);
                }
            }
            if (totalViewsSet.size() == 0) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: adding empty viewsSet for:" + objectName);
                }
                this.addEmptyView(objectName);
                return false;
            }
            return this.addViews(objectName, totalViewsSet);
        }
        return false;
    }

    private synchronized IJMXDataView createSpringBootView(ObjectName objectName, MBeanServer server, String attName, Object attKey, String attType, String resourceName) {
        AJMXDataView view;
        block14: {
            boolean isTraceEnabled = this.isTraceEnabled(sModule);
            if (attName == null || attType == null) {
                if (isTraceEnabled) {
                    this.trace(sModule, "DIAG: attribute name or type was null " + attName + " : " + attType);
                }
                return null;
            }
            view = null;
            String fullIntroscopeMetricName = resourceName;
            boolean bShouldPollMetric = this.shouldPollMetric(fullIntroscopeMetricName, attName);
            boolean bShouldPollRateCounterMetric = false;
            bShouldPollRateCounterMetric = this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName);
            if (bShouldPollMetric || bShouldPollRateCounterMetric) {
                try {
                    boolean isLegacyJSR77;
                    if (interpreterJSR77.isAvailable() && interpreterJSR77.isQualified(attType)) {
                        int colonPos = fullIntroscopeMetricName.lastIndexOf(":");
                        String rootIntroscopeMetricName = colonPos < 0 ? fullIntroscopeMetricName : fullIntroscopeMetricName.substring(0, colonPos);
                        if (!this.haveAlreadySeenObjectName(objectName)) {
                            if (bShouldPollMetric && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName, interpreterJSR77, false, attKey)) != null && isTraceEnabled) {
                                this.trace(sModule, "DIAG: new polled MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                            }
                            if (bShouldPollRateCounterMetric && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName = rootIntroscopeMetricName + kRateCounterExtension, interpreterJSR77, true, attKey)) != null && isTraceEnabled) {
                                this.trace(sModule, "DIAG: new rate counter MBeanInterpreterJMXDataView + " + fullIntroscopeMetricName);
                            }
                        }
                        break block14;
                    }
                    boolean bl = isLegacyJSR77 = fullIntroscopeMetricName.indexOf("|JSR77|") >= 0;
                    if (!this.allowLegacyJSR77 && isLegacyJSR77 || this.haveAlreadySeenObjectName(objectName)) break block14;
                    try {
                        if (bShouldPollMetric && (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName, this.fExcludeStringMetrics, false, attKey)) != null && isTraceEnabled) {
                            this.trace(sModule, "DIAG: new legacy polled view (" + attType + ") " + fullIntroscopeMetricName);
                        }
                        if (bShouldPollRateCounterMetric && (view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName = fullIntroscopeMetricName + kRateCounterExtension, this.fExcludeStringMetrics, true, attKey)) != null && isTraceEnabled) {
                            this.trace(sModule, "DIAG: new legacy rate counter polled view (" + attType + ") " + fullIntroscopeMetricName);
                        }
                    }
                    catch (AccumulatorAlreadyExistsException ae) {
                        if (isTraceEnabled) {
                            this.trace(sModule, ae.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
                    String message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Could_Not_Create_View_Message", fullIntroscopeMetricName, objectName.toString() + " " + attName + " " + attType);
                    fAgent.IAgent_safeReportError(message, (Throwable)e);
                }
            }
        }
        return view;
    }

    private boolean shouldPollRateCounterMetric(String metricName, String attName) {
        Assertion.wilyAssert((boolean)false);
        if (!JMXDelegatingService.sIsJMXRateCounterEnabled) {
            return false;
        }
        if (this.fRateCounterFilters.length == 0) {
            return this.shouldPollMetric(metricName, attName);
        }
        for (int i = 0; i < this.fRateCounterFilters.length; ++i) {
            Filter filter = this.fRateCounterFilters[i];
            if (!filter.matches(metricName)) continue;
            return true;
        }
        return false;
    }

    private String getIntroscopeResourceName(ObjectName on) {
        String result = null;
        if (this.fPrimaryNameConverter.IMBeanNameConverter_canConvert(on)) {
            result = this.fPrimaryNameConverter.IMBeanNameConverter_convert(on);
        } else {
            Assertion.wilyAssert((boolean)false);
            result = this.fSecondaryNameConverter.IMBeanNameConverter_convert(on);
        }
        return result;
    }

    private synchronized boolean addViews(ObjectName on, Set viewsSet) {
        if (!this.haveAlreadySeenObjectName(on)) {
            Assertion.wilyAssert((boolean)false);
            this.fViewsHashMap.put(on, viewsSet);
            return true;
        }
        return false;
    }

    private synchronized boolean addEmptyView(ObjectName on) {
        if (!this.haveAlreadySeenObjectNameWithEmptyViews(on)) {
            this.fEmptyViewsHashMap.put(on, null);
            return true;
        }
        return false;
    }

    public void clearViewsMaps() {
        if (this.fViewsHashMap != null && this.fEmptyViewsHashMap != null && this.fServersHashSet != null) {
            for (Object objName : this.fViewsHashMap.keySet()) {
                Set viewsHash = (Set)this.fViewsHashMap.get(objName);
                Iterator iterator = viewsHash.iterator();
                while (iterator.hasNext()) {
                    IJMXDataView view = (IJMXDataView)iterator.next();
                    view.IJMXDataView_destroy();
                    iterator.remove();
                }
            }
            this.fViewsHashMap.clear();
            this.fEmptyViewsHashMap.clear();
            this.fServersHashSet.clear();
        }
    }

    private synchronized HashSet removeViews(ObjectName on) {
        Assertion.wilyAssert((boolean)false);
        return (HashSet)this.fViewsHashMap.remove(on);
    }

    private synchronized HashSet removeEmptyViews(ObjectName on) {
        Assertion.wilyAssert((boolean)false);
        return (HashSet)this.fEmptyViewsHashMap.remove(on);
    }

    private synchronized boolean haveAlreadySeenObjectName(ObjectName on) {
        return this.fViewsHashMap.containsKey(on);
    }

    private synchronized boolean haveAlreadySeenObjectNameWithEmptyViews(ObjectName on) {
        return this.fEmptyViewsHashMap.containsKey(on);
    }

    private synchronized void removeMBean(ObjectName on, MBeanServer server) {
        Iterator iterator;
        boolean isDebugEnabled = this.isTraceEnabled(sModule);
        boolean isTraceEnabled = fAgent.IAgent_getModuleFeedback().isTraceEnabled(sModule);
        HashSet views = this.removeViews(on);
        HashSet emptyViews = this.removeEmptyViews(on);
        if (views != null) {
            if (isDebugEnabled) {
                this.trace(sModule, "DIAG: removeMBean " + (on != null ? on.toString() : "null object") + " with " + views.size() + " views");
            }
            iterator = views.iterator();
            while (iterator.hasNext()) {
                IJMXDataView view = (IJMXDataView)iterator.next();
                if (isTraceEnabled) {
                    fAgent.IAgent_getModuleFeedback().trace(sModule, "DIAG: removeMBean removing view " + view.getFullMetricName() + "  " + views.size());
                }
                view.IJMXDataView_destroy();
                iterator.remove();
            }
        }
        if (emptyViews != null) {
            if (isDebugEnabled) {
                this.trace(sModule, "DIAG: removeMBean " + (on != null ? on.toString() : "null object") + " with no view set");
            }
            iterator = emptyViews.iterator();
            while (iterator.hasNext()) {
                iterator.remove();
            }
        }
    }

    boolean isDebugEnabled(Module sModule) {
        return this.fForceDebugToInfo || fAgent.IAgent_getModuleFeedback().isDebugEnabled(sModule);
    }

    boolean isTraceEnabled(Module sModule) {
        return this.fForceDebugToInfo || fAgent.IAgent_getModuleFeedback().isTraceEnabled(sModule);
    }

    void trace(Module module, String string) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string);
        } else {
            fAgent.IAgent_getModuleFeedback().trace(module, string);
        }
    }

    void trace(Module module, String string, Throwable t) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string, t);
        } else {
            fAgent.IAgent_getModuleFeedback().trace(module, string, t);
        }
    }

    void debug(Module module, String string) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string);
        } else {
            fAgent.IAgent_getModuleFeedback().debug(module, string);
        }
    }

    void debug(Module module, String string, Throwable t) {
        if (this.fForceDebugToInfo) {
            fAgent.IAgent_getModuleFeedback().info(module, string, t);
        } else {
            fAgent.IAgent_getModuleFeedback().debug(module, string, t);
        }
    }

    void debug_ForceDebugAtInfo(boolean value) {
        this.fForceDebugToInfo = value;
    }

    private int getNumberOfViewsForMBean(ObjectName objectName) {
        HashSet views = (HashSet)this.fViewsHashMap.get(objectName);
        int size = views.size();
        if (objectName.getCanonicalName().startsWith("org.springframework.boot") && (objectName.getCanonicalName().contains("metricsEndpoint") || objectName.getCanonicalName().contains("dumpEndpoint"))) {
            for (Object view : views) {
                if (!(view instanceof SpringBootEndpointDataView)) continue;
                size = size - 1 + ((SpringBootEndpointDataView)view).getViewSize();
            }
        }
        return size;
    }

    IMBeanNameConverter debug_getSecondaryNameConverter() {
        return this.fSecondaryNameConverter;
    }

    int debug_getNumberOfMBeans() {
        return this.fViewsHashMap.size();
    }

    int debug_getNumberOfViewsForMBean(ObjectName on, MBeanServer server) {
        return this.getNumberOfViewsForMBean(on);
    }

    boolean debug_locatedMBeanServer(MBeanServer server) {
        return this.fServersHashSet.contains(server);
    }

    int debug_getNumberLocatedMBeanServers() {
        return this.fServersHashSet.size();
    }

    void debug_parseConfigProperties(IndexedProperties props) {
        this.parseConfigProperties(props);
    }

    boolean debug_shouldPollMetric(String fullIntroscopeMetricName) {
        return this.shouldPollMetric(fullIntroscopeMetricName, null);
    }

    void debug_findServersAndPollViews() {
        this.setContextAndPoll();
    }

    void debug_DumpViewsStats() {
        this.DumpViewsStats();
    }

    private HashMap parseSpringBootDumpEndpointData(ObjectName objectName, MBeanServer server, boolean isDebugEnabled, Set totalViewsSet, String resourceName, String attName, String attType, Object attValue) {
        HashMap<String, IJMXDataView> viewsMap = new HashMap<String, IJMXDataView>();
        JsonParser parser = new JsonParser();
        ArrayList attValueList = (ArrayList)attValue;
        for (int i = 0; i < attValueList.size(); ++i) {
            try {
                String inputString = attValueList.get(i).toString();
                String threadName = inputString.substring(1, inputString.indexOf(","));
                if (fJmxSpringbootThreadsList == null || !fJmxSpringbootThreadsList.contains(threadName.split("=")[1])) continue;
                String json = inputString.replace(threadName + ",", "");
                json = json.replace("#", "_");
                for (String s : fJmxSpringbootThreadsFilterCharList) {
                    threadName = threadName.replace(s, "_");
                }
                JsonElement ele = parser.parse(json.trim());
                if (!ele.isJsonObject()) continue;
                JsonObject obj = ele.getAsJsonObject();
                Set<Map.Entry<String, JsonElement>> entries = obj.entrySet();
                SpringbootData dataObj = null;
                for (Map.Entry<String, JsonElement> entry : entries) {
                    dataObj = SpringbootData.getSpringbootDataObject(entry.getKey());
                    if (dataObj == null) continue;
                    String customAttType = dataObj != null ? dataObj.getDataType() : attType;
                    String customMetricName = dataObj != null ? dataObj.getPrettyName() : ":" + entry.getKey();
                    StringBuilder sb = new StringBuilder();
                    sb.append(resourceName);
                    sb.append("|");
                    sb.append(threadName);
                    sb.append(customMetricName);
                    IJMXDataView view = this.createSpringBootView(objectName, server, attName, entry.getKey(), customAttType, sb.toString());
                    if (view == null) continue;
                    viewsMap.put(threadName + entry.getKey(), view);
                    if (!isDebugEnabled) continue;
                    this.trace(sModule, "DIAG: Creating view for - " + sb.toString());
                }
                continue;
            }
            catch (JsonParseException e) {
                if (!isDebugEnabled) continue;
                this.trace(sModule, "DIAG: Parse exception while creating view - " + objectName + " - " + attValueList.get(i).toString());
            }
        }
        return viewsMap;
    }

    private HashMap parseSpringBootMetricsEndpointData(ObjectName objectName, MBeanServer server, boolean isDebugEnabled, String resourceName, String attName, String attType, Object attValue) {
        HashMap<String, IJMXDataView> viewsMap = new HashMap<String, IJMXDataView>();
        LinkedHashMap map = (LinkedHashMap)attValue;
        for (Object o : map.keySet()) {
            IJMXDataView view;
            String customAttType;
            String customMetricName;
            StringBuilder sb;
            String[] parts;
            String key = o.toString();
            Object value = map.get(key);
            SpringbootData dataObj = SpringbootData.getSpringbootDataObject(key);
            if (key.startsWith("datasource.")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("DataSource");
                for (int i = 1; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("jvm.memory.heap")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("JVM");
                sb.append("|");
                sb.append("Memory");
                sb.append("|");
                sb.append("Heap");
                for (int i = 3; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("jvm.memory.non-heap")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("JVM");
                sb.append("|");
                sb.append("Memory");
                sb.append("|");
                sb.append("Non Heap");
                for (int i = 3; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("jvm.memory.pools")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("JVM");
                sb.append("|");
                sb.append("Memory");
                sb.append("|");
                sb.append("Pools");
                for (int i = 3; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("jvm.threads")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("JVM");
                sb.append("|");
                sb.append("Threads");
                for (int i = 2; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("integration.channel")) {
                parts = key.split("\\.");
                sb = new StringBuilder();
                sb.append(resourceName);
                sb.append("|");
                sb.append("Integration Channel");
                for (int i = 2; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        sb.append(":");
                        sb.append(parts[i]);
                        continue;
                    }
                    sb.append("|");
                    sb.append(parts[i]);
                }
                customMetricName = sb.toString();
                customAttType = "long";
            } else if (key.startsWith("integration.handler.org.springframework.integration")) {
                String temp = key.replace("integration.handler.org.springframework.integration.", "");
                String[] parts2 = temp.split("\\.");
                StringBuilder sb2 = new StringBuilder();
                sb2.append(resourceName);
                sb2.append("|");
                sb2.append("Integration Handler");
                sb2.append("|");
                sb2.append("org.springframework.integration");
                for (int i = 0; i < parts2.length; ++i) {
                    if (i == parts2.length - 1) {
                        sb2.append(":");
                        sb2.append(parts2[i]);
                        continue;
                    }
                    sb2.append("|");
                    sb2.append(parts2[i]);
                }
                customMetricName = sb2.toString();
                customAttType = "long";
            } else {
                StringBuilder sb3 = new StringBuilder();
                sb3.append(resourceName);
                if (dataObj != null) {
                    sb3.append(dataObj.getPrettyName());
                } else {
                    sb3.append(":");
                    sb3.append(key);
                }
                customAttType = dataObj != null ? dataObj.getDataType() : attType;
                customMetricName = sb3.toString();
            }
            if ((view = this.createSpringBootView(objectName, server, attName, key, customAttType, customMetricName)) == null) continue;
            viewsMap.put(key, view);
            if (!isDebugEnabled) continue;
            this.trace(sModule, "DIAG: Creating view for - " + customMetricName);
        }
        return viewsMap;
    }

    static {
        fSyncWithAllMbeanServersForcibly = false;
        fCanRunForcedDiscovery = false;
        fLastTime = 0L;
    }

    private final class MBeanForcedDiscoveryControllingService
    implements ITimestampedRunnable {
        private MBeanForcedDiscoveryControllingService() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            fCanRunForcedDiscovery = true;
            long interval = nowInMillis - fLastTime;
            if (fLastTime == 0L) {
                interval = 0L;
            }
            if (IntroscopeProtocolAdaptor.this.isTraceEnabled(sModule)) {
                IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: MBeanForcedDiscoveryControllingService called - fCanRunForcedDiscovery = " + fCanRunForcedDiscovery + "(" + interval + " mS)");
            }
            fLastTime = nowInMillis;
        }
    }

    private final class IntroscopeProtocolAdaptorHeartbeatBehavior
    implements ITimestampedRunnable {
        private IntroscopeProtocolAdaptorHeartbeatBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode()) {
                return;
            }
            IntroscopeProtocolAdaptor.this.setContextAndPoll();
        }
    }

    private final class IntroscopeNotificationListener
    implements NotificationListener {
        private IntroscopeNotificationListener() {
        }

        @Override
        public void handleNotification(Notification notification, final Object server) {
            try {
                boolean isDebugEnabled = IntroscopeProtocolAdaptor.this.isTraceEnabled(sModule);
                Assertion.wilyAssert((boolean)false);
                Assertion.wilyAssert((boolean)false);
                if (notification instanceof MBeanServerNotification) {
                    final MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                    if (mbsn.getType().equals("JMX.mbean.registered")) {
                        if (isDebugEnabled) {
                            IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: MBeanServerNotification.REGISTRATION_NOTIFICATION");
                        }
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem((IExecutableItem)new ASimpleExecutableItem(){

                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.this.addMBean2(mbsn.getMBeanName(), (MBeanServer)server);
                            }
                        });
                    } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                        if (isDebugEnabled) {
                            IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: MBeanServerNotification.UNREGISTRATION_NOTIFICATION");
                        }
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem((IExecutableItem)new ASimpleExecutableItem(){

                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.this.removeMBean2(mbsn.getMBeanName(), (MBeanServer)server);
                            }
                        });
                    } else if (isDebugEnabled) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: MBeanServerNotification = " + mbsn.getType());
                    }
                } else if (isDebugEnabled) {
                    if (notification instanceof AttributeChangeNotification) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification AttributeChangeNotification from " + notification.getSource().toString());
                    } else if (notification instanceof MonitorNotification) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification MonitorNotification from " + notification.getSource().toString());
                    } else if (notification instanceof RelationNotification) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification RelationNotification from " + notification.getSource().toString());
                    } else if (notification instanceof TimerNotification) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification TimerNotification from " + notification.getSource().toString());
                    } else if (notification instanceof Notification) {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification - javax.management.Notification from " + notification.getSource().toString());
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification - javax.management.Notification value " + notification.getMessage().toString());
                    } else {
                        IntroscopeProtocolAdaptor.this.trace(sModule, "DIAG: JMX Notification UNKNOWN!" + notification.getClass().toString());
                    }
                }
            }
            catch (Throwable t) {
                try {
                    fAgent.IAgent_safeReportError(fAgent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_Error_Handling_Notification_Message"), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static final class MBeanForcedPollingEnabledProperty
    extends BooleanConfigurationProperty {
        public MBeanForcedPollingEnabledProperty(IAgent agent) {
            super(IntroscopeProtocolAdaptor.kSyncWithAllMbeanServersForcibly, Boolean.FALSE, fAgent.IAgent_getModuleFeedback(), sModule, fAgent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fSyncWithAllMbeanServersForcibly = (Boolean)newValue;
        }
    }

    private class RemoveMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private RemoveMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.removeMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }

    private class AddMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private AddMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.addMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }

    private class FindServersAndPollViewsAction
    implements PrivilegedAction {
        private FindServersAndPollViewsAction() {
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.findServersAndPollViews();
            return null;
        }
    }
}

