/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IBoundaryBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blamestackfeature.AgentEventReceiver;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.blamestackfeature.IBoundaryBlameStackFeature;
import com.wily.introscope.agent.blamestackfeature.IEventReceiver;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelper;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BoundaryBlameStack
extends BlameStackFeatureBlameStack
implements IBoundaryBlameStack,
IBlameStack {
    private String fHeadNode;
    private String fVetoedFrontend;
    private List fPropagateErrorNodes;
    private String fBackend;
    private String fVetoedBackend;
    private String fTailNodeName;
    private String[] fDefaultBackendData;
    private int fComponentsPastTail;
    private ILongIntervalCounterDataAccumulator fHeadErrorAccumulator;
    private Map fPropagatedErrorAccumulators;
    private ILongIntervalCounterDataAccumulator fTailErrorAccumulator;
    private boolean fUnsetTail;
    private boolean fInBackend;
    private IBoundaryBlameStackHelper fHelper;
    private static final String kErrorsMetricSuffix = ":Errors Per Interval";

    public BoundaryBlameStack(List featureFactories) {
        this(featureFactories, AgentEventReceiver.INSTANCE);
    }

    public BoundaryBlameStack(List featureFactories, IEventReceiver receiver) {
        super(featureFactories, receiver);
        this.initialize();
    }

    private void initialize() {
        this.fHelper = ComponentTracer.getDefaultBoundaryBlameStackHelperProvider().getCurrentThreadHelper();
        this.fHelper.setBoundaryBlameStack(this);
        this.fVetoedFrontend = this.fHeadNode = this.fHelper.getFrontend();
        this.fPropagateErrorNodes = new ArrayList();
        this.fVetoedBackend = this.fBackend = this.fHelper.getBackend();
        this.fTailNodeName = null;
        this.fDefaultBackendData = null;
        this.fComponentsPastTail = 0;
        this.fUnsetTail = false;
        this.fInBackend = this.fHelper.isInBackend();
        this.fHeadErrorAccumulator = null;
        this.fTailErrorAccumulator = null;
        this.fPropagatedErrorAccumulators = new HashMap();
    }

    private void ensureBounds(String component) {
        if (this.fInBackend) {
            ++this.fComponentsPastTail;
        }
    }

    private ILongIntervalCounterDataAccumulator getAccumulator(String name) {
        try {
            ILongIntervalCounterDataAccumulator accumulator = AgentShim.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(name);
            return accumulator;
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError("Help, I've fallen and I can't get up!", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBoundaryComponent() {
        Object object = this.getLock();
        synchronized (object) {
            String result = null;
            if (this.fHeadNode != null) {
                result = !this.fInBackend ? this.fHeadNode : this.fBackend;
            } else if (this.fBackend != null) {
                result = this.fBackend;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBoundaryComponentForErrorsWithVetoes() {
        Object object = this.getLock();
        synchronized (object) {
            String result = null;
            if (this.fHeadNode != null) {
                result = !this.fInBackend ? (this.fHeadNode.equals(this.fVetoedFrontend) ? null : this.fHeadNode) : (this.fBackend.equals(this.fVetoedBackend) ? null : this.fBackend);
            } else if (this.fBackend != null) {
                result = this.fBackend.equals(this.fVetoedBackend) ? null : this.fBackend;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDefaultBackendData() {
        Object object = this.getLock();
        synchronized (object) {
            return this.fDefaultBackendData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackSnapshot snap = BlameStackSnapshot.kEmptyBlameStackSnapshot;
            if (this.fHeadNode != null) {
                snap = BlameStackSnapshot.getBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot, this.fHeadNode);
            }
            return snap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHeadComponentName() {
        Object object = this.getLock();
        synchronized (object) {
            return this.fHeadNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureBounds(component);
            this.push(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureBounds(component);
            BlameStackFeatureStackEntry newStackEntry = this.push(component);
            newStackEntry.decorate(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        Object object = this.getLock();
        synchronized (object) {
            this.ensureBounds(component);
            BlameStackFeatureStackEntry newStackEntry = this.push(component);
            newStackEntry.decorate(paramName, paramValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        Object object = this.getLock();
        synchronized (object) {
            BlameStackSnapshot snap = BlameStackSnapshot.kEmptyBlameStackSnapshot;
            if (component != null && this.fBackend != null && component.equals(this.fBackend) && this.fHeadNode != null) {
                snap = BlameStackSnapshot.getBlameStackSnapshot(this.fHeadNode);
            }
            return snap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void IBlameStack_removeComponent(String component) {
        Object object = this.getLock();
        synchronized (object) {
            if (component == null) {
                return;
            }
            if (this.fComponentsPastTail > 0) {
                --this.fComponentsPastTail;
                if (this.fInBackend && component.equals(this.fBackend)) {
                    this.fInBackend = false;
                    this.fHelper.signalBackendPopped(this.fBackend);
                    if (this.fComponentsPastTail == 0) {
                        this.fUnsetTail = true;
                    }
                }
            } else if (this.fComponentsPastTail == 0 && this.fBackend != null) {
                this.fUnsetTail = true;
                this.fInBackend = false;
                this.fHelper.signalBackendPopped(this.fBackend);
            }
            if (component.equals(this.fHeadNode)) {
                this.fHeadNode = null;
                this.fHelper.signalFrontendPopped(this.fHeadNode);
            }
            this.pop();
        }
    }

    @Override
    public void IBlameStack_tearDown() {
        super.IBlameStack_tearDown();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean incrementOrInstantiateBoundaryError(boolean increment) {
        Object object = this.getLock();
        synchronized (object) {
            boolean result = false;
            String boundaryComponent = this.getBoundaryComponentForErrorsWithVetoes();
            if (boundaryComponent != null) {
                if (boundaryComponent.equals(this.fHeadNode)) {
                    if (this.fHeadErrorAccumulator == null) {
                        String metricName = this.fHeadNode + kErrorsMetricSuffix;
                        this.fHeadErrorAccumulator = this.getAccumulator(metricName);
                    }
                    if (increment) {
                        this.fHeadErrorAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        this.fHeadErrorAccumulator.forceMetricToExist(this.IBlameStack_getSnapshot(this.fHeadNode));
                    }
                    for (String markedFrontEndNode : this.fPropagateErrorNodes) {
                        ILongIntervalCounterDataAccumulator accumulator = (ILongIntervalCounterDataAccumulator)this.fPropagatedErrorAccumulators.get(markedFrontEndNode);
                        if (accumulator == null) {
                            String metricName = markedFrontEndNode + kErrorsMetricSuffix;
                            accumulator = this.getAccumulator(metricName);
                        }
                        if (increment) {
                            accumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
                            continue;
                        }
                        accumulator.forceMetricToExist(this.IBlameStack_getSnapshot(markedFrontEndNode));
                    }
                    result = true;
                } else if (boundaryComponent.equals(this.fBackend)) {
                    if (this.fTailErrorAccumulator == null) {
                        String metricName = this.fBackend + ":" + "Errors Per Interval";
                        this.fTailErrorAccumulator = this.getAccumulator(metricName);
                    }
                    if (increment) {
                        this.fTailErrorAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident(this.IBlameStack_getSnapshot(this.fBackend));
                    } else {
                        this.fTailErrorAccumulator.forceMetricToExist(this.IBlameStack_getSnapshot(this.fBackend));
                    }
                    result = true;
                }
            }
            return result;
        }
    }

    private void informFeaturesOfBackend(String backendName) {
        for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
            IBlameStackFeature feature = this.features[atFeature];
            feature.setEndBoundary(backendName);
        }
        this.fHelper.signalNewBackend(backendName);
    }

    @Override
    public boolean noteBoundaryError() {
        return this.incrementOrInstantiateBoundaryError(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendName) {
        Object object = this.getLock();
        synchronized (object) {
            if (!this.IBlameStack_isEmpty() && (this.fBackend == null || this.fUnsetTail)) {
                String currentComponent = componentToReplace;
                this.fDefaultBackendData = new String[2];
                this.fDefaultBackendData[0] = currentComponent;
                this.fDefaultBackendData[1] = backendName;
                this.setEndBoundary(backendName);
                this.fUnsetTail = false;
            }
        }
    }

    public void unsetEndBoundary(String component) {
        if (this.fComponentsPastTail > 0) {
            --this.fComponentsPastTail;
            if (this.fInBackend && component.equals(this.fBackend)) {
                this.fInBackend = false;
                this.fHelper.signalBackendPopped(this.fBackend);
            }
        } else if (this.fComponentsPastTail == 0 && this.fBackend != null) {
            this.fUnsetTail = true;
            this.fInBackend = false;
            this.fHelper.signalBackendPopped(this.fBackend);
        }
    }

    public void unsetFrontBoundary(String component) {
        if (component.equals(this.fHeadNode)) {
            this.fHeadNode = null;
            this.fHelper.signalFrontendPopped(this.fHeadNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndBoundary(String component) {
        Object object = this.getLock();
        synchronized (object) {
            boolean canSet;
            this.fInBackend = true;
            boolean isDefaultBackend = this.fBackend != null && this.fDefaultBackendData != null && this.fBackend.equals(this.fDefaultBackendData[1]);
            boolean bl = canSet = this.fBackend == null || isDefaultBackend;
            if (canSet || this.fUnsetTail) {
                this.fTailNodeName = this.fBackend = component;
                this.informFeaturesOfBackend(this.fTailNodeName);
                this.fUnsetTail = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrontBoundary(String component) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.fHeadNode != null) {
                this.fPropagateErrorNodes.add(this.fHeadNode);
            }
            this.fHeadNode = component;
            for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
                IBlameStackFeature feature = this.features[atFeature];
                feature.setFrontBoundary(component);
            }
            this.fHelper.signalNewFrontend(this.fHeadNode);
        }
    }

    @Override
    public void setComponentMetricPropagateFlag(String component, int flag) {
        if ((flag & 2) != 0) {
            if (!this.fPropagateErrorNodes.contains(component)) {
                this.fPropagateErrorNodes.add(component);
            }
        } else if (!this.fPropagateErrorNodes.contains(component)) {
            this.fPropagateErrorNodes.remove(component);
        }
        for (int atFeature = 0; atFeature < this.featuresSize; ++atFeature) {
            IBlameStackFeature feature = this.features[atFeature];
            if (!(feature instanceof IBoundaryBlameStackFeature)) continue;
            ((IBoundaryBlameStackFeature)((Object)feature)).setComponentMetricPropagateFlag(component, flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFrontBoundary() {
        Object object = this.getLock();
        synchronized (object) {
            return this.fHeadNode != null;
        }
    }

    @Override
    public String toString() {
        return "[BoundaryBlameStack: head=" + this.fHeadNode + ", tail=" + this.fBackend + "]";
    }

    public void addVetoedBackendInErrors(String backend) {
        this.fVetoedBackend = backend;
    }

    public void addVetoedFrontendInErrors(String frontend) {
        this.fVetoedFrontend = frontend;
    }

    public void removeVetoedBackendInErrors() {
        this.fVetoedBackend = null;
    }

    public void removeVetoedFrontendInErrors() {
        this.fVetoedFrontend = null;
    }
}

