/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.IsengardClientConnection;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.postoffice.PostOffice;

public class ConnectedServer {
    private IServerFailoverPolicy fServerFailoverPolicy;
    private ServerInstanceLocator fServerLocator;
    private IsengardClientConnection fIsengardConnection;

    public ConnectedServer(IsengardClientConnection connection, IServerFailoverPolicy policy, ServerInstanceLocator serverLocator) {
        this.fIsengardConnection = connection;
        this.fServerFailoverPolicy = policy;
        this.fServerLocator = serverLocator;
    }

    public void addBean(Class beanClass, Object param) throws BeanActivationException {
        this.fIsengardConnection.addBean(beanClass, param);
    }

    public boolean isConnected() {
        return this.fIsengardConnection.isConnected();
    }

    public boolean isConnectedToPrimaryEM() {
        if (!this.isConnected()) {
            return false;
        }
        String primaryEMHostName = this.getFailoverPolicy().getFailbackServer().getHostName();
        int primaryEMPort = this.getFailoverPolicy().getFailbackServer().getPort();
        String currentEMHostName = this.getServerLocator().getHostName();
        int currentEMPort = this.getServerLocator().getPort();
        return primaryEMHostName.equals(currentEMHostName) && primaryEMPort == currentEMPort;
    }

    public ServerInstanceLocator getServerLocator() {
        return this.fServerLocator;
    }

    private IServerFailoverPolicy getFailoverPolicy() {
        return this.fServerFailoverPolicy;
    }

    public PostOffice getPostOffice() {
        return this.fIsengardConnection.getPostOffice();
    }

    public void forceDisconnect() {
        this.fIsengardConnection.tearDownConnection();
    }
}

