/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.enterprise;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class AgentWrapperLoader {
    private static final String kAgentWrapperPluginType = "agentwrapper";
    private static final int kCurrentAgentWrapperPluginVersion = 1;
    private static final Class[] kAgentWrapperConstructorParameterTypes = new Class[]{IAgent.class};
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final ExtensionAdministrator fExtensionAdministrator;

    public AgentWrapperLoader(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ExtensionAdministrator extensionAdministrator) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fExtensionAdministrator = extensionAdministrator;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    public IAgent createAgentWrapper(IAgent delegate) {
        IPlugin[] plugins = this.fExtensionAdministrator.getAgentPluginsByType(kAgentWrapperPluginType);
        if (plugins == null || plugins.length == 0) {
            return delegate;
        }
        IPlugin plugin = plugins[0];
        Class wrapperClass = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, IAgent.class);
        if (wrapperClass != null) {
            try {
                Constructor constructor = wrapperClass.getConstructor(kAgentWrapperConstructorParameterTypes);
                return (IAgent)constructor.newInstance(delegate);
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", wrapperClass.getName()));
                this.getModuleFeedback().verbose(target);
            }
            catch (NoSuchMethodException nsme) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", wrapperClass.getName()));
            }
            catch (SecurityException se) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", wrapperClass.getName()));
            }
            catch (Throwable t) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", wrapperClass.getName()));
                this.getModuleFeedback().verbose(t);
            }
        }
        return delegate;
    }
}

