/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueMapCache<K, V> {
    ConcurrentLinkedQueue<K> queue = new ConcurrentLinkedQueue();
    ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    final QueueObserver<K, V> observer;

    public QueueMapCache(QueueObserver<K, V> observer) {
        this.observer = observer;
    }

    public void initializeQueue(K entry, int size) {
        for (int i = 0; i < size; ++i) {
            this.queue.add(entry);
        }
    }

    public boolean addToQueue(K guid, V val) {
        if (this.map.putIfAbsent(guid, val) == null) {
            this.removeFromQueue();
            this.queue.add(guid);
            this.observer.elementAdded(guid, val);
            return true;
        }
        return false;
    }

    public V getValue(K guid) {
        return this.map.get(guid);
    }

    public void updateValue(K guid, V val) {
        this.map.put(guid, val);
    }

    public void removeFromQueue() {
        K guid = this.queue.poll();
        if (guid != null) {
            V val = this.map.remove(guid);
            if (this.observer != null) {
                this.observer.elementRemoved(guid, val);
            }
        }
    }

    public ArrayList<K> getMapEntries() {
        return new ArrayList<K>(this.queue);
    }

    public void init() {
        this.queue.clear();
        this.map.clear();
    }

    public static interface QueueObserver<K, V> {
        public void elementAdded(K var1, V var2);

        public void elementRemoved(K var1, V var2);
    }
}

