/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.io.ASocketNameFormatter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramSendMethodNameFormatter
extends ASocketNameFormatter {
    public DatagramSendMethodNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected ASocketNameFormatter.ResourceAndAddress getResourceAndAddress(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel && data.hasInvocationParametersAvailable() && data.getInvocationParameterAsObject(1) instanceof InetSocketAddress) {
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)data.getInvocationParameterAsObject(1);
            String resourceName = DatagramChannelMap.getResourceName(channel, remoteAddress);
            InetSocketAddress address = DatagramChannelMap.getAddress(channel, remoteAddress);
            InetSocketAddress localAddress = (InetSocketAddress)channel.socket().getLocalSocketAddress();
            if (resourceName != null && address != null) {
                return new ASocketNameFormatter.ResourceAndAddress(resourceName, localAddress, address);
            }
        }
        return null;
    }
}

