/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.sink;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.messageprimitives.sink.MessageSink;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;

public class RegisteredMessageSink<T>
extends MessageSink<T> {
    private final String fServiceName;

    public RegisteredMessageSink(PostOffice po, Class<T> sinkInterface, String path, ISinkNotification controlChannel) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        super(po, sinkInterface, controlChannel);
        this.fServiceName = "/sink/" + sinkInterface.getName() + "/" + path;
        this.registerService();
    }

    public RegisteredMessageSink(PostOffice po, Class<T> sinkInterface, ISinkNotification controlChannel) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        super(po, sinkInterface, controlChannel);
        this.fServiceName = "/sink/" + sinkInterface.getName();
        this.registerService();
    }

    public RegisteredMessageSink(PostOffice po, Class<T> sinkInterface) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        super(po, sinkInterface);
        this.fServiceName = "/sink/" + sinkInterface.getName();
        this.registerService();
    }

    private void registerService() throws EntryAlreadyExistsException, InvalidPathException, ConnectionException {
        RegistryEntry entry = new RegistryEntry();
        IRegistryService client = this.getPostOffice().getRegistry();
        entry.setAddress(this.getAddress());
        entry.setProperty("Interface", this.getSinkClass().getName());
        client.addEntry(this.getAddress().getPostOffice(), new DirectoryPath(this.fServiceName), entry);
    }

    @Override
    public void close() {
        this.unregisterService();
        super.close();
    }

    private void unregisterService() {
        try {
            IRegistryService client = this.getPostOffice().getRegistry();
            client.deleteEntry(new DirectoryPath(this.fServiceName));
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (ConnectionException connectionException) {}
    }

    @Override
    public String toString() {
        return String.valueOf(this.fServiceName) + " (" + this.getSinkClass().getName() + ")";
    }
}

