/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.IIdentityKey;
import com.wily.util.adt.SimpleIdentityKey;
import com.wily.util.adt.WeakIdentityKey;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentWeakIdentityHighPerformanceLRUHashMap<K, V>
extends ConcurrentHighPerformanceLRUHashMap<IIdentityKey<K>, V> {
    private final Object fBehaviorKillLock = new Object();
    private volatile WaitAndExecuteBehavior fStaleCheckBehavior;
    private final AtomicReference<SimpleIdentityKey<K>>[] identityKeys;
    protected volatile transient ReferenceQueue<Object> fWeakReferenceQueue = new ReferenceQueue();
    protected static final Module kModule = new Module("ConcurrentWeakIdentityHighPerformanceLRUHashMap");

    public ConcurrentWeakIdentityHighPerformanceLRUHashMap() {
        this(16, 16);
    }

    public ConcurrentWeakIdentityHighPerformanceLRUHashMap(int maxSize) {
        this(16, maxSize);
    }

    public ConcurrentWeakIdentityHighPerformanceLRUHashMap(int concurrency, int maxSize) {
        super(concurrency, maxSize);
        this.identityKeys = new AtomicReference[concurrency];
        int i = 0;
        while (i < this.identityKeys.length) {
            this.identityKeys[i] = new AtomicReference<SimpleIdentityKey<Object>>(new SimpleIdentityKey<Object>(null));
            ++i;
        }
    }

    @Override
    protected final int getIndex(Object key) {
        int hashCode = System.identityHashCode(key);
        return (hashCode & Integer.MAX_VALUE) % this.fConcurrency;
    }

    public final V putWeak(K key, V value) {
        int index = this.getIndex(key);
        return this.put(index, new WeakIdentityKey<K>(key, this.fWeakReferenceQueue), value);
    }

    public final V putWeakIfAbsent(K key, V value) {
        int index = this.getIndex(key);
        return this.putIfAbsent(index, new WeakIdentityKey<K>(key, this.fWeakReferenceQueue), value);
    }

    public final V removeWeak(K key) {
        int index = this.getIndex(key);
        SimpleIdentityKey<K> sik = this.getIdentityKey(key, index);
        Object result = this.remove(index, (Object)sik);
        this.releaseIdentityKey(sik, index);
        return result;
    }

    public final V getWeak(K key) {
        int index = this.getIndex(key);
        SimpleIdentityKey<K> sik = this.getIdentityKey(key, index);
        Object result = this.get(index, sik);
        this.releaseIdentityKey(sik, index);
        return result;
    }

    public final boolean containsWeakKey(K key) {
        int index = this.getIndex(key);
        SimpleIdentityKey<K> sik = this.getIdentityKey(key, index);
        boolean result = this.containsKey(index, sik);
        this.releaseIdentityKey(sik, index);
        return result;
    }

    private final SimpleIdentityKey<K> getIdentityKey(K key, int index) {
        SimpleIdentityKey<K> sik = this.identityKeys[index].getAndSet(null);
        if (sik == null) {
            sik = new SimpleIdentityKey<K>(key);
        } else {
            sik.set(key);
        }
        return sik;
    }

    private void releaseIdentityKey(SimpleIdentityKey<K> sik, int index) {
        sik.set(null);
        this.identityKeys[index].set(sik);
    }

    public final void removeStaleKeys() {
        Reference<Object> key;
        boolean isTraceEnabled = this.getFeedback() != null ? this.getFeedback().isTraceEnabled(kModule) : true;
        int initialSize = 0;
        if (isTraceEnabled) {
            initialSize = this.size();
        }
        if (isTraceEnabled) {
            this.getFeedback().trace(kModule, "Starting check for stale keys at " + new Date() + " on a map size of " + initialSize);
        }
        int removeCount = 0;
        while ((key = this.fWeakReferenceQueue.poll()) != null) {
            int index = this.getIndexFromHashCode(key.hashCode());
            Object removed = this.remove(index, (Object)key);
            if (!isTraceEnabled || removed == null) continue;
            ++removeCount;
        }
        if (isTraceEnabled) {
            this.getFeedback().trace(kModule, "End check for stale keys at " + new Date() + ": map size = " + this.size());
        }
        if (isTraceEnabled && removeCount > 0) {
            this.getFeedback().trace(kModule, "Check for stale keys: initial size = " + initialSize + ", removed = " + removeCount + ", size = " + this.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStaleCheck(IntervalHeartbeat heartbeat, long staleCheckFrequency) {
        Object object = this.fBehaviorKillLock;
        synchronized (object) {
            if (this.fStaleCheckBehavior != null) {
                this.fStaleCheckBehavior.kill();
            }
            this.fStaleCheckBehavior = new WaitAndExecuteBehavior(heartbeat, staleCheckFrequency, String.valueOf(System.identityHashCode(this)) + "concurrentMapStaleCheck"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean execute() {
                    Object object = ConcurrentWeakIdentityHighPerformanceLRUHashMap.this.fBehaviorKillLock;
                    synchronized (object) {
                        ConcurrentWeakIdentityHighPerformanceLRUHashMap.this.removeStaleKeys();
                        return false;
                    }
                }
            };
        }
    }
}

