/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.sampling.ISampler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;

abstract class IntervalBasedSampler
implements ISampler {
    private boolean fEnabled;
    protected int fDuration;
    protected int fSamplesCountPerInterval;
    protected IntervalHeartbeat fTimer;
    private final ITimestampedRunnable fTimerBehavior = new ITimestampedRunnable(){

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            IntervalBasedSampler.this.onDurationExpired();
        }
    };
    private IRegisteredBehavior fTimerRegisteredBehavior;
    protected IModuleFeedbackChannel fFeedback;

    IntervalBasedSampler() {
    }

    @Override
    public void configure(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fTimer = agent.IAgent_getCommonHeartbeat();
        this.initMainTimer();
    }

    protected void cleanup() {
        this.fTimerRegisteredBehavior.close();
        this.fTimerRegisteredBehavior = null;
    }

    protected void initMainTimer() {
        if (this.fTimer == null) {
            return;
        }
        if (this.fTimerRegisteredBehavior != null) {
            this.cleanup();
        }
        if (!this.isEnabled()) {
            return;
        }
        String name = this.name();
        if (this.fFeedback.isTraceEnabled(kSamplingModule)) {
            this.fFeedback.trace(kSamplingModule, "Initializing main timer for " + name + ", interval duration is " + this.fDuration);
        }
        this.fTimerRegisteredBehavior = this.fTimer.addBehavior(this.fTimerBehavior, "TT Sampling " + name, true, (long)(this.fDuration * 1000), true);
    }

    @Override
    public void enable(boolean value) {
        if (value == this.fEnabled) {
            return;
        }
        this.fEnabled = value;
        this.initMainTimer();
    }

    protected boolean isEnabled() {
        return this.fEnabled;
    }

    protected void updateSamplingDuration(int duration) {
        if (duration == this.fDuration) {
            return;
        }
        this.fDuration = duration;
        this.initMainTimer();
    }

    protected void updateSamplesCountPerInterval(int value) {
        if (this.fSamplesCountPerInterval == value) {
            return;
        }
        this.fSamplesCountPerInterval = value;
        this.initMainTimer();
    }

    protected abstract void onDurationExpired();
}

