/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramReceiveMethodMappingTracer
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public DatagramReceiveMethodMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel");
        return null;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return;
        }
        if (data.isSocketClamped()) {
            return;
        }
        DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
        if (data.hasMethodResultAvailable()) {
            Object result = data.getInvocationReturnValueAsObject();
            if (result != null) {
                if (result instanceof InetSocketAddress) {
                    InetSocketAddress remoteAddress = (InetSocketAddress)result;
                    InetSocketAddress localAddress = new InetSocketAddress(channel.socket().getLocalAddress(), channel.socket().getLocalPort());
                    DatagramChannelMap.put(channel, remoteAddress, this.getNameParameter(), localAddress, false);
                } else {
                    Assertion.wilyAssert("Instrumentation error: instrumented method return value is not an InetSocketAddress");
                }
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented method return value is not available");
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }
}

