/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.api.instrument.ClassRedefinitionWriter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;

public class AClassRetransformationDelegate
extends AClassRedefinitionDelegate {
    private static final Module kModule = new Module("ClassRetransformationDelegate");
    private final ClassRedefinitionWriter fClassRedefinitionWriter;

    public AClassRetransformationDelegate(Instrumentation t, IAgent agent) {
        super(t, agent);
        this.fClassRedefinitionWriter = ClassRedefinitionWriter.getClassRedefinitionWriter(this.fAgent);
    }

    @Override
    protected void doClassRedefinition(Instrumentation fInstrumentation, IModuleFeedbackChannel fFeedback, IStringLocalizer fLocalizer, int fClassFileSizeLimit, Class cls, IClassRedefinitionCallback callback) throws IOException, ClassNotFoundException, UnmodifiableClassException {
        boolean isModifiableClass = fInstrumentation.isModifiableClass(cls);
        boolean isDebugEnabled = fFeedback.isDebugEnabled(kModule);
        if (!isModifiableClass && isDebugEnabled) {
            fFeedback.debug(kModule, "Class " + cls.getName() + " is not going to be retransformed, because the class is unmodifiable.");
            throw new UnmodifiableClassException(cls.getName());
        }
        try {
            try {
                fInstrumentation.retransformClasses(cls);
            }
            catch (UnmodifiableClassException e) {
                fFeedback.info(kModule, "Class " + cls.getName() + " has not been retransformed, because the JVM threw UnmodifiableClassException. Using redefinition.");
                super.doClassRedefinition(fInstrumentation, fFeedback, fLocalizer, fClassFileSizeLimit, cls, callback);
                return;
            }
            try {
                byte[] classBytes = null;
                if (this.fClassRedefinitionWriter.shouldSaveRetransformedClass() && callback != null) {
                    classBytes = ByteClassUtil.getBytesForClass(cls, fClassFileSizeLimit, fFeedback);
                    if (classBytes != null) {
                        if (ByteClassUtil.byteArrayToInt(classBytes, 0) == -889275714) {
                            ByteArrayInputStream stream = new ByteArrayInputStream(classBytes);
                            this.fClassRedefinitionWriter.saveRetransformedClass(cls, classBytes);
                            if (callback != null) {
                                callback.executeOnRedefinition(cls, stream);
                            }
                            if (isDebugEnabled) {
                                fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class", cls.getName()));
                            }
                        } else if (isDebugEnabled) {
                            fFeedback.debug(fLocalizer.IStringLocalizer_getFormattedLocalizedString("Redefined_Class_Skipped", cls.getName()));
                        }
                    } else if (isDebugEnabled) {
                        fFeedback.debug(kModule, "Could not obtain class bytes for the class -" + cls.getName());
                    }
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t1) {
                String message = "Unexpected exception when getting bytes for " + cls.getName() + ";" + cls.getClassLoader();
                fFeedback.warn(kModule, message);
                fFeedback.debug(kModule, message, t1);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            String message = "Unexpected exception when retransforming " + cls.getName() + ";" + cls.getClassLoader();
            fFeedback.warn(kModule, message);
            fFeedback.debug(kModule, message, t);
        }
    }
}

