/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.graph;

import com.wily.introscope.spec.server.graph.ADirectedGraphVisitor;
import com.wily.introscope.spec.server.graph.IEdge;
import com.wily.introscope.spec.server.graph.IVertex;
import com.wily.introscope.spec.server.graph.TraversalEdgeType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TopologicalSortVisitor<V extends IVertex, E extends IEdge>
extends ADirectedGraphVisitor<V, E> {
    private List<V> fVertices = new LinkedList<V>();
    private int fCurrentIndex = -1;

    @Override
    public void acceptVertex(V visitVertex) {
        this.fVertices.add(visitVertex);
        this.fCurrentIndex = this.fVertices.size() - 1;
    }

    @Override
    public void acceptEdge(V fromVertex, E visitEdge, TraversalEdgeType et, V toVertex) {
        int toIndex;
        if ((et == TraversalEdgeType.FORWARD || et == TraversalEdgeType.CROSS) && this.fCurrentIndex > (toIndex = this.fVertices.lastIndexOf(toVertex))) {
            this.fVertices.add(this.fCurrentIndex--, (IVertex)this.fVertices.remove(toIndex));
            this.fCurrentIndex = toIndex;
        }
    }

    public List<V> topologicalSort() {
        LinkedList<V> sorted = new LinkedList<V>(this.fVertices);
        Collections.reverse(sorted);
        return sorted;
    }
}

