/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class LongHashtable<T> {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 1.0f;
    private Entry<T>[] fTable;
    private int fCount;

    public LongHashtable() {
        this(11);
    }

    public LongHashtable(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fCount = 0;
        this.fTable = new Entry[initialCapacity];
    }

    public synchronized int getSize() {
        return this.fCount;
    }

    public synchronized void put(long key, T value) {
        int index = (int)(++key & Integer.MAX_VALUE) % this.fTable.length;
        Entry<T> e = this.fTable[index];
        while (e != null) {
            if (e.fKey == key) {
                e.fValue = value;
                return;
            }
            e = e.fNext;
        }
        e = this.fTable[index];
        Entry newEntry = new Entry(key, value, e);
        this.fTable[index] = newEntry;
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 1.0f) {
            this.rehash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long key) {
        Entry<T>[] table = this.fTable;
        int index = (int)(++key & Integer.MAX_VALUE) % table.length;
        if (key == 0L) {
            LongHashtable longHashtable = this;
            synchronized (longHashtable) {
                Entry<T> e = table[index];
                while (e != null) {
                    if (e.fKey == key) {
                        return e.fValue;
                    }
                    e = e.fNext;
                }
            }
        } else {
            Entry<T> e = table[index];
            while (e != null) {
                if (e.fKey == key) {
                    return e.fValue;
                }
                e = e.fNext;
            }
        }
        return null;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        Entry<T>[] entryArray = this.fTable;
        int n = this.fTable.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry;
            Entry<T> e = entry = entryArray[n2];
            Entry nextE = null;
            while (e != null) {
                nextE = e.fNext;
                int newIndex = (int)(e.fKey & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++n2;
        }
        this.fTable = newTable;
    }

    public synchronized Enumeration<T> elements() {
        return new HashtableEnumerator<T>(this.fTable);
    }

    private static final class Entry<T> {
        long fKey;
        T fValue;
        Entry<T> fNext;

        private Entry(long key, T val, Entry<T> next) {
            this.fKey = key;
            this.fValue = val;
            this.fNext = next;
        }
    }

    private static final class HashtableEnumerator<T>
    implements Enumeration<T> {
        int fIndex;
        Entry<T>[] fTableSnapshot;
        Entry<T> fEntry;

        HashtableEnumerator(Entry<T>[] table) {
            this.fTableSnapshot = table;
            this.fIndex = table.length;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasMoreElements() {
            if (this.fEntry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.fEntry = this.fTableSnapshot[this.fIndex];
                if (this.fEntry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.fIndex-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        @Override
        public T nextElement() {
            if (this.fEntry == null) {
                while (this.fIndex-- > 0 && (this.fEntry = this.fTableSnapshot[this.fIndex]) == null) {
                }
            }
            if (this.fEntry != null) {
                Entry<T> e = this.fEntry;
                this.fEntry = e.fNext;
                return e.fValue;
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }
}

