/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class ProtocolListTracer
extends ASingleInstanceTracerFactory {
    private static final String kPrependClientHandler = "com.wily.introscope.soa.client.prependhandler";
    private static final String kAppendServerHandler = "com.wily.introscope.soa.server.appendhandler";
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private IAgent agent = null;
    private IModuleFeedbackChannel logger = null;
    private String agentHome = null;

    public ProtocolListTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.agentHome = WSMUtils.getAbsoluteAgentPath();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_finishTrace(int index, InvocationData invocationData) {
        try {
            boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kPrependClientHandler, true);
            if (!prop) {
                this.executeWilyHandler(invocationData);
            }
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("ProtocolListTracer: " + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void ITracer_startTrace(int index, InvocationData invocationData) {
        try {
            boolean prop = AgentShim.getAgentShim().IAgentShim_getAgent().IAgent_getIndexedProperties().getBooleanProperty(kPrependClientHandler, true);
            if (prop) {
                this.executeWilyHandler(invocationData);
            }
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("ProtocolListTracer: " + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void executeWilyHandler(InvocationData invocationData) {
        Object parent = null;
        Object wsCl = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Start In ProtocolListTracer:ITracer_startTrace");
            this.logger.debug("agentHome:" + this.agentHome);
        }
        try {
            String strMethod = invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName();
            String strWSDMClientProtocolMethod = "";
            strWSDMClientProtocolMethod = strMethod.equals("handleRequest") ? "handleRequest" : (strMethod.equals("handleResponse") ? "handleResponse" : "handleFault");
            String strWSDMClientProtocol = "com.wily.powerpack.webservices.handlers.netweaver.client.WSDMClientProtocol";
            String messageParamStr = "com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage";
            String propertyContextStr = "com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext";
            ClassLoader wilyCL = WSMUtils.getWilyClassLoader();
            if (wilyCL == null) {
                this.logger.debug("Ignore ProtocolListTracer invocation before RuntimeProcessingEnvironment is created");
                return;
            }
            Class<?> wsdmClientProtocolClz = Class.forName(strWSDMClientProtocol, true, wilyCL);
            Class<?> messageParamClz = Class.forName(messageParamStr, true, wilyCL);
            Class<?> propertyContextClz = Class.forName(propertyContextStr, true, wilyCL);
            Method wsdmClientProtocolMethod = wsdmClientProtocolClz.getDeclaredMethod(strWSDMClientProtocolMethod, messageParamClz, propertyContextClz);
            Object messageParam = messageParamClz.cast(invocationData.getInvocationParameterAsObject(0));
            Object propertyContext = invocationData.getInvocationParameterAsObject(1);
            wsdmClientProtocolMethod.invoke(WSMUtils.getWsdmRpcClientProtocol(), messageParam, propertyContext);
        }
        catch (Throwable t) {
            StackTraceElement[] arr = t.getStackTrace();
            StringBuilder buf = new StringBuilder();
            for (int m = 0; m < arr.length; ++m) {
                buf.append(arr[m].toString() + "\n");
            }
            this.logger.debug("Unable to Execute WSDMClientProtocol.<method>" + buf.toString());
            this.logger.debug("Unable to Execute WSDMClientProtocol.<method> " + t);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("End In ProtocolListTracer:ITracer_startTrace");
        }
    }
}

