/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.weblogic;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.weblogic9.WsdmWebLogic90Handler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.handler.JaxrpcHandlerChain;
import weblogic.wsee.monitoring.HandlerStats;
import weblogic.wsee.ws.dispatch.server.JaxrpcChainHandler;

public class WLS9ModifyHandler {
    public static final int kType_HandlerClient = 0;
    public static final int kType_HandlerServer = 1;
    private static ThreadLocal Cache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private static final HandlerStats kEmptyHandlerStats = new WLS9EmptyHandlerStats();

    public static HandlerInfo getClientHandler() {
        return ClientHandlerHolder.wsdmHandler;
    }

    public static HandlerInfo getServerHandler() {
        return ServerHandlerHolder.wsdmHandler;
    }

    public static void set(Object key, Object value) {
        WLS9ModifyHandler.get().put(key, value);
    }

    public static Object get(Object key) {
        return WLS9ModifyHandler.get().get(key);
    }

    private static Map get() {
        return (Map)Cache.get();
    }

    public static void clear() {
        WLS9ModifyHandler.get().clear();
    }

    public static HandlerInfo getWSDMHandler(Hashtable config) {
        HandlerInfo WSDMHandler = null;
        try {
            HandlerList handlers = new HandlerList();
            handlers.add("WSDM Weblogic 9 Handler", new HandlerInfo(WsdmWebLogic90Handler.class, (Map)config, null));
            JaxrpcHandlerChain handlerChain = new JaxrpcHandlerChain(handlers);
            handlerChain.init();
            config.put("weblogic.wsee.handler.jaxrpcHandlerChain", handlerChain);
            config.put("weblogic.wsee.handler.jaxrpcHandlerChainPoolSize", "0");
            WSDMHandler = new HandlerInfo(JaxrpcChainHandler.class, (Map)config, null);
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            WSMUtils.getLogger().error("getWSDMHandler " + WSMUtils.dumpStackTrace(bomb));
        }
        return WSDMHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerList modifyHandlerList(HandlerList handlers) {
        HandlerList newHandlers = handlers;
        WSMUtils.refreshLogLevels();
        try {
            WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList");
            String dispatcherType = (String)WLS9ModifyHandler.get("com.wily.powerpack.webservices.WLS9Dispatcher");
            if (dispatcherType != null) {
                if (dispatcherType.equals("weblogic.wsee.ws.dispatch.server.ServerDispatcher")) {
                    WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList ServerDispatcher");
                    newHandlers = WLS9ModifyHandler.getServerHandlerList(handlers);
                } else if (dispatcherType.equals("weblogic.wsee.ws.dispatch.client.ClientDispatcher")) {
                    WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList ClientDispatcher");
                    newHandlers = WLS9ModifyHandler.getClientHandlerList(handlers);
                } else {
                    WSMUtils.getLogger().debug("Detected unsupported Weblogic 9 dispatcher");
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable th) {
            try {
                WSMUtils.getLogger().error("WLS9ModifyHandler modifyHandlerList " + WSMUtils.dumpStackTrace(th));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            newHandlers = handlers;
        }
        finally {
            try {
                WLS9ModifyHandler.clear();
                if (WSMUtils.getLogger().isDebugEnabled()) {
                    WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList: Handler Order");
                    for (int iter = 0; iter < newHandlers.size(); ++iter) {
                        WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList(" + iter + "):" + newHandlers.getName(iter));
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return newHandlers;
    }

    private static int getHandlerAppendPoint(HandlerList handlers, int handlerType) {
        int insertPoint = WLS9ModifyHandler.findHandler("JAX_RPC_CHAIN_HANDLER", handlers);
        if (insertPoint == -1) {
            String handlerName = 0 == handlerType ? "ADDRESSING_HANDLER" : "CODEC_HANDLER";
            insertPoint = WLS9ModifyHandler.findHandler("CODEC_HANDLER", handlers);
            if (insertPoint == -1) {
                insertPoint = Math.max(0, handlers.size() - 1);
            }
        } else {
            ++insertPoint;
        }
        return insertPoint;
    }

    protected static synchronized HandlerList appendWSDMHandler(HandlerList handlers, HandlerInfo WSDMHandler, int handlerType) throws WSDMHandlerInstantiationException {
        WSMUtils.getLogger().debug("WLS9ModifyHandler: Appending WSDM handler to handler chain");
        if (handlers != null) {
            String name;
            String string = name = handlerType == 0 ? "WSDM Observer Client Handler" : "WSDM Server Observer Handler";
            if (!handlers.contains(name)) {
                int insertPoint = WLS9ModifyHandler.getHandlerAppendPoint(handlers, handlerType);
                try {
                    handlers.insert(name, insertPoint, WSDMHandler);
                }
                catch (HandlerException bomb) {
                    throw new WSDMHandlerInstantiationException(bomb);
                }
                try {
                    if (handlers.getStats(insertPoint) != null) {
                        handlers.insert(insertPoint, kEmptyHandlerStats);
                    }
                }
                catch (Throwable bomb) {
                    try {
                        handlers.remove(insertPoint);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new WSDMHandlerInstantiationException(bomb);
                }
            }
        }
        return handlers;
    }

    private static HandlerList getServerHandlerList(HandlerList handlers) throws AgentNotAvailableException, WSDMHandlerInstantiationException {
        HandlerInfo wsdmHandler = WLS9ModifyHandler.getServerHandler();
        boolean prop = WSMUtils.appendServerHandlerEnabled();
        return prop ? WLS9ModifyHandler.appendWSDMHandler(handlers, wsdmHandler, 1) : WLS9ModifyHandler.prependWSDMHandler(handlers, wsdmHandler, 1);
    }

    private static int getHandlerPrependPoint(HandlerList handlers, int handlerType) {
        int insertPoint = WLS9ModifyHandler.findHandler("JAX_RPC_CHAIN_HANDLER", handlers);
        if (insertPoint == -1) {
            String handlerName = 0 == handlerType ? "ADDRESSING_HANDLER" : "CODEC_HANDLER";
            insertPoint = WLS9ModifyHandler.findHandler("ADDRESSING_HANDLER", handlers) + 1;
        }
        return insertPoint;
    }

    protected static synchronized HandlerList prependWSDMHandler(HandlerList handlers, HandlerInfo WSDMHandler, int handlerType) throws WSDMHandlerInstantiationException {
        WSMUtils.getLogger().debug("WLS9ModifyHander::prependWSDMHandler");
        if (handlers != null) {
            String name;
            String string = name = handlerType == 0 ? "WSDM Observer Client Handler" : "WSDM Server Observer Handler";
            if (!handlers.contains(name)) {
                int insertPoint = WLS9ModifyHandler.getHandlerPrependPoint(handlers, handlerType);
                try {
                    handlers.insert(name, insertPoint, WSDMHandler);
                }
                catch (HandlerException bomb) {
                    throw new WSDMHandlerInstantiationException(bomb);
                }
                try {
                    if (handlers.getStats(insertPoint) != null) {
                        handlers.insert(insertPoint, kEmptyHandlerStats);
                    }
                }
                catch (Throwable bomb) {
                    try {
                        handlers.remove(insertPoint);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    throw new WSDMHandlerInstantiationException(bomb);
                }
            }
        }
        return handlers;
    }

    private static HandlerList getClientHandlerList(HandlerList handlers) throws AgentNotAvailableException, WSDMHandlerInstantiationException {
        HandlerInfo wsdmHandler = WLS9ModifyHandler.getClientHandler();
        boolean prop = WSMUtils.prependClientHandlerEnabled();
        return prop ? WLS9ModifyHandler.prependWSDMHandler(handlers, wsdmHandler, 0) : WLS9ModifyHandler.appendWSDMHandler(handlers, wsdmHandler, 0);
    }

    protected static int findHandler(String handlerName, HandlerList handlers) {
        int pos = -1;
        if (handlers != null) {
            for (int iter = 0; iter < handlers.size() && pos < 0; ++iter) {
                if (!handlers.getName(iter).equals(handlerName)) continue;
                pos = iter;
            }
        }
        return pos;
    }

    private static class WLS9EmptyHandlerStats
    implements HandlerStats {
        private WLS9EmptyHandlerStats() {
        }

        public void reportInitError(Throwable throwable) {
        }

        public void reportRequestTermination() {
        }

        public void reportRequestError(Throwable throwable) {
        }

        public void reportResponseTermination() {
        }

        public void reportResponseError(Throwable throwable) {
        }
    }

    private static class ServerHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ServerHandlerHolder() {
        }

        static {
            wsdmHandler = WLS9ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
        }
    }

    private static class ClientHandlerHolder {
        public static HandlerInfo wsdmHandler = null;

        private ClientHandlerHolder() {
        }

        static {
            wsdmHandler = WLS9ModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
        }
    }
}

