/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator.common;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.servletheaderdecorator.common.PPAbstractTracer;
import com.wily.introscope.agent.servletheaderdecorator.common.SimpleMethodCache;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrivateMethodCache {
    static Object g_PMCLockObj;
    private int m_startIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateMethodCache(int size, String[] methodNames, String[] overrideClassNames) {
        Object object = g_PMCLockObj;
        synchronized (object) {
            int oldLength = PPAbstractTracer.m_methodCache.m_methodNames.length;
            int newLength = oldLength + size;
            String[] newMethodNames = new String[newLength];
            System.arraycopy(PPAbstractTracer.m_methodCache.m_methodNames, 0, newMethodNames, 0, oldLength);
            System.arraycopy(methodNames, 0, newMethodNames, oldLength, size);
            String[] newOverrideClassNames = new String[newLength];
            System.arraycopy(PPAbstractTracer.m_methodCache.m_overrideClassNames, 0, newOverrideClassNames, 0, oldLength);
            System.arraycopy(overrideClassNames, 0, newOverrideClassNames, oldLength, size);
            PPAbstractTracer.m_methodCache = new SimpleMethodCache(newLength, newMethodNames, newOverrideClassNames);
            this.m_startIndex = oldLength;
        }
    }

    public int getActualIndex(int clientIndex) {
        return this.m_startIndex + clientIndex;
    }

    public Method getMethod(Object object, int clientIndex, InvocationData invocationData, Class[] argClassArray, String tracerName) {
        int actualIndex = this.getActualIndex(clientIndex);
        return PPAbstractTracer.m_methodCache.getMethod(object, actualIndex, invocationData, argClassArray, tracerName);
    }

    public String getMethodName(int clientIndex) {
        return PPAbstractTracer.m_methodCache.getMethodName(this.getActualIndex(clientIndex));
    }

    public Object invoke1ArgReturnsObject(InvocationData data, int methodIndex, Object thisObject, Object arg0, Class arg0Class, String callerName) {
        if (thisObject == null) {
            return null;
        }
        Class[] argClassArray = new Class[]{arg0Class};
        Method targetMethod = this.getMethod(thisObject, methodIndex, data, argClassArray, callerName);
        if (targetMethod == null) {
            AgentShim.handleError((String)("Error: " + callerName + " no " + this.getMethodName(methodIndex) + " method found"), null);
            return null;
        }
        try {
            Object[] args = new Object[]{arg0};
            return targetMethod.invoke(thisObject, args);
        }
        catch (InvocationTargetException ite) {
            String classMethodName = "Unknown";
            if (data != null) {
                ProbeIdentification pid = data.getProbeInformation().getProbeIdentification();
                classMethodName = pid.getProbeClassName() + " " + pid.getProbeMethodName();
            }
            AgentShim.handleError((String)("Error: " + callerName + " a problem occurred while accessing " + this.getMethodName(methodIndex) + ": " + classMethodName), (Throwable)ite.getTargetException());
            return null;
        }
        catch (Exception e) {
            String classMethodName = "Unknown";
            if (data != null) {
                ProbeIdentification pid = data.getProbeInformation().getProbeIdentification();
                classMethodName = pid.getProbeClassName() + " " + pid.getProbeMethodName();
            }
            AgentShim.handleError((String)("Error: " + callerName + " a problem occurred while accessing " + this.getMethodName(methodIndex) + ": " + classMethodName), (Throwable)e);
            return null;
        }
    }

    public void invokeReturnsVoid(InvocationData data, int methodIndex, Object thisObject, Object[] args, Class[] argClassArray, String callerName) {
        if (thisObject == null) {
            return;
        }
        Method targetMethod = this.getMethod(thisObject, methodIndex, data, argClassArray, callerName);
        if (targetMethod == null) {
            AgentShim.handleError((String)("Error: " + callerName + " no " + this.getMethodName(methodIndex) + " method found"), null);
            return;
        }
        try {
            targetMethod.invoke(thisObject, args);
        }
        catch (InvocationTargetException ite) {
            Throwable reportMe;
            String classMethodName = "Unknown";
            if (data != null) {
                ProbeIdentification pid = data.getProbeInformation().getProbeIdentification();
                classMethodName = pid.getProbeClassName() + " " + pid.getProbeMethodName();
            }
            if ((reportMe = ite.getTargetException()) instanceof ExceptionInInitializerError) {
                reportMe = ((ExceptionInInitializerError)reportMe).getException();
            }
            AgentShim.handleError((String)("Error: " + callerName + " a problem occurred while accessing " + this.getMethodName(methodIndex) + ": " + classMethodName), (Throwable)reportMe);
            return;
        }
        catch (Exception e) {
            String classMethodName = "Unknown";
            if (data != null) {
                ProbeIdentification pid = data.getProbeInformation().getProbeIdentification();
                classMethodName = pid.getProbeClassName() + " " + pid.getProbeMethodName();
            }
            AgentShim.handleError((String)("Error: " + callerName + " a problem occurred while accessing " + this.getMethodName(methodIndex) + ": " + classMethodName), (Throwable)e);
            return;
        }
    }

    public Object getObjectResult(InvocationData invocationData, Object objThis, int iMethodIndex, String callerName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        try {
            Method m = this.getMethod(objThis, iMethodIndex, invocationData, new Class[0], callerName);
            return m.invoke(objThis, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            AgentShim.handleError((String)"getObjectResult: IllegalArgumentException", null);
        }
        catch (IllegalAccessException ex) {
            AgentShim.handleError((String)"getObjectResult: IllegalAccessException", null);
        }
        catch (InvocationTargetException ex) {
            AgentShim.handleError((String)"getObjectResult: InvocationTargetException", null);
        }
        catch (SecurityException ex) {
            AgentShim.handleError((String)"getObjectResult: SecurityException", null);
        }
        catch (Exception ex) {
            AgentShim.handleError((String)("getObjectResult: Exception" + ex), null);
            ex.printStackTrace();
        }
        return null;
    }

    static {
        PPAbstractTracer.m_methodCache = new SimpleMethodCache(0, new String[0], new String[0]);
        g_PMCLockObj = new Object();
    }
}

