/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.ConsoleLogger;
import com.wily.introscope.agent.launch.core.FileLocker;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileLock;
import java.util.logging.Level;

public class BootstrapAgentLogger
implements Logger {
    private String primaryFileName;
    private String secondaryFileName;
    private String currentFileNameToWrite;
    private static FileLocker fileLocker;
    private static Logger logger;
    private static final Logger CONSOLE_LOGGER;
    private static final long kMaxLogFileSizeInMB = 1L;

    private BootstrapAgentLogger(String logsDir) throws IOException {
        if (logsDir == null) {
            throw new NullPointerException("logsDir input for BootstrapAgentLogger is NULL.");
        }
        this.primaryFileName = logsDir + File.separator + "BootstrapAgent.log";
        this.createNewFile(this.primaryFileName);
        this.currentFileNameToWrite = this.primaryFileName;
        this.secondaryFileName = logsDir + File.separator + "BootstrapAgent.1.log";
        fileLocker = new FileLocker(logsDir + File.separator + ".lock");
    }

    public static Logger getLogger() {
        if (logger == null) {
            try {
                logger = new BootstrapAgentLogger(BootstrapAgentUtil.getBootstrapAgentLogsFolderPath());
            }
            catch (ThreadDeath e) {
                e.printStackTrace(System.err);
                logger = CONSOLE_LOGGER;
            }
            catch (Throwable th) {
                CONSOLE_LOGGER.severe("Failed to initialze BootstrapAgent logger");
                logger = CONSOLE_LOGGER;
            }
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logUsingLock(String msg) {
        String content = BootstrapAgentUtil.prepareLoggingMsg(msg);
        FileLock lock = fileLocker.tryUntilAcquiredOrMaxRetries(100L, 5);
        PrintWriter currentWriter = null;
        if (lock != null) {
            try {
                currentWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFileNameToWrite, true), "UTF-8"));
                currentWriter.write(content);
                currentWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (currentWriter != null) {
                    currentWriter.close();
                }
                fileLocker.releaseLock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnMaxReach() {
        FileLock lock = null;
        try {
            lock = fileLocker.tryUntilAcquiredOrMaxRetries(100L, 5);
            if (lock == null) {
                CONSOLE_LOGGER.severe("Unable to rename log file because of unsuccessful file lock attempt.");
                return;
            }
            File sFile = new File(this.secondaryFileName);
            if (sFile.exists() && !sFile.delete()) {
                CONSOLE_LOGGER.severe("Failed to delete secondary file " + sFile);
                return;
            }
            boolean renamed = new File(this.primaryFileName).renameTo(sFile);
            if (!renamed) {
                CONSOLE_LOGGER.severe("Unable to rename log file");
                return;
            }
            this.createNewFile(this.primaryFileName);
        }
        catch (IOException e) {
            CONSOLE_LOGGER.severe("Unable to create log file");
        }
        finally {
            fileLocker.releaseLock(lock);
        }
    }

    public static void clearContent(String filePath) {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(filePath);
            writer.print("");
        }
    }

    @Override
    public void info(String msg) {
        try {
            this.checkMaxAndWrite(msg);
        }
        catch (ThreadDeath th) {
            th.printStackTrace();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }

    @Override
    public void fine(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void finer(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void severe(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void warning(String msg) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void log(Level severe, String msg, Throwable t) {
        this.checkMaxAndWrite(msg);
    }

    @Override
    public void log(Level severe, String s, ThreadDeath td) {
        this.checkMaxAndWrite(s);
    }

    public void tearDown() {
    }

    private boolean checkMaxAndWrite(String msg) {
        if (logger == CONSOLE_LOGGER) {
            CONSOLE_LOGGER.severe(msg);
        } else {
            long usedSpace = new File(this.currentFileNameToWrite).length();
            double sizeInMB = usedSpace / 0x100000L;
            if (sizeInMB >= 1.0) {
                this.doOnMaxReach();
            }
            this.logUsingLock(msg);
        }
        return true;
    }

    private File createNewFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            if (!file.canWrite()) {
                String message = "Bootstrap Agent Logger does not have write permission for file: " + path;
                CONSOLE_LOGGER.severe(message);
                throw new IOException(path);
            }
        } else {
            try {
                file.createNewFile();
                BootstrapAgentUtil.fixGroupPermissionsForSharedAccess(file);
            }
            catch (IOException e) {
                CONSOLE_LOGGER.severe("Failed to create file: " + path + ". Please check file permissions.");
                throw e;
            }
        }
        return file;
    }

    static {
        logger = null;
        CONSOLE_LOGGER = new ConsoleLogger();
    }
}

