/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform.builder;

import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.cmp.transform.SubstituteStaticMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import java.util.Map;

public final class SubstituteStaticMethodTransformationBuilder
implements ITransformationBuilder {
    private final TracerGroupBuilder fTracerGroupBuilder;
    private final FullyQualifiedMethodName fSourceMethod;
    private final FullyQualifiedMethodName fReplacementMethod;

    public SubstituteStaticMethodTransformationBuilder(FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) {
        this(null, sourceMethod, replacementMethod);
    }

    public SubstituteStaticMethodTransformationBuilder(TracerGroupBuilder tracerGroupBuilder, FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) {
        this.fTracerGroupBuilder = tracerGroupBuilder;
        this.fSourceMethod = sourceMethod;
        this.fReplacementMethod = replacementMethod;
    }

    public TracerGroupBuilder getTracerGroupBuilder() {
        return this.fTracerGroupBuilder;
    }

    public FullyQualifiedMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    public FullyQualifiedMethodName getReplacementMethod() {
        return this.fReplacementMethod;
    }

    @Override
    public ITransformation generateTransformation(ICompilerLog log, IClassName instrumentationClass, Map tracerGroups) {
        TracerGroup tracerGroup = this.getTracerGroupBuilder() == null ? null : this.getTracerGroupBuilder().lookupTracerGroup(tracerGroups);
        return new SubstituteStaticMethodTransformation(log, tracerGroup, this.getSourceMethod(), this.getReplacementMethod());
    }
}

