/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;

public class SynchronizedDataStructure
implements IRepository {
    private ISharedElement sharedValue;
    private final ISharedElement kInstancer;
    private volatile boolean fShutOff = false;

    public SynchronizedDataStructure(ISharedElement instance) {
        this.kInstancer = instance;
        this.sharedValue = this.kInstancer.getSharedElementInstance();
    }

    @Override
    public synchronized void offer(ISharedElement offered) {
        if (this.sharedValue == null) {
            this.sharedValue = offered;
        } else {
            this.sharedValue.merge(offered);
        }
    }

    public String toString() {
        return Thread.currentThread().getName() + " value = " + this.sharedValue;
    }

    @Override
    public synchronized ISharedElement get() {
        ISharedElement result = this.sharedValue;
        if (result == null) {
            return this.kInstancer.getSharedElementInstance();
        }
        this.sharedValue = null;
        return result;
    }

    @Override
    public synchronized void reset() {
        this.sharedValue = this.kInstancer.getSharedElementInstance();
    }

    @Override
    public synchronized ISharedElement read() {
        ISharedElement tryGet = this.get();
        ISharedElement result = tryGet.getSharedElementInstance();
        return this.read(result);
    }

    @Override
    public synchronized ISharedElement read(ISharedElement result) {
        ISharedElement tryGet = this.get();
        result.merge(tryGet);
        if (tryGet.shouldBeConsumendOnRead()) {
            tryGet.reset();
        } else {
            tryGet.resetMinMax();
        }
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SynchronizedDataStructure(instance);
    }

    @Override
    public synchronized void update(IUpdater updater, long value, long startTime, int hashcode) {
        ISharedElement element = this.get();
        updater.update(element, value, startTime);
        this.offer(element);
    }

    @Override
    public boolean hasNotChanged() {
        return false;
    }

    @Override
    public boolean shouldBeHarvested() {
        return true;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (!offerBack) {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

