/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.environment.CallbackFailedPermanentlyException;
import com.wily.introscope.agent.environment.CallbackFailedTemporarilyException;
import com.wily.introscope.agent.webappsupport.AWebAppAgentNamer;
import com.wily.introscope.agent.webappsupport.websphere.AdminServiceBean;
import com.wily.util.StringUtils;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class WebSphereAgentNamer
extends AWebAppAgentNamer {
    public WebSphereAgentNamer(IAgent agent) {
        super(agent);
    }

    public String IAppserverEnvironmentInfoCallback_getAgentName() throws CallbackFailedTemporarilyException, CallbackFailedPermanentlyException {
        String kGetCellNameMethodName = "getCellName";
        String kGetProcessNameMethodName = "getProcessName";
        Object adminService = this.getAdminService();
        if (adminService == null) {
            throw new CallbackFailedTemporarilyException((ILocalizableMessage)new SimpleLocalizableMessage("Null_WebSphere_Admin_Service_Message"));
        }
        String cell = this.getStringResultOfMethod(adminService, "getCellName");
        String process = this.getStringResultOfMethod(adminService, "getProcessName");
        if (StringUtils.isEmpty((String)cell) && StringUtils.isEmpty((String)process)) {
            return null;
        }
        return StringUtils.concatAndEscapeStrings((String)cell, (String)process, (char)'/', (char)'_');
    }

    private Object getAdminService() throws CallbackFailedPermanentlyException {
        Object result = null;
        try {
            result = AdminServiceBean.getAdminService();
        }
        catch (ClassNotFoundException cnf) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new SimpleLocalizableMessage("Admin_Service_Factory_Class_Not_Found_Message"), (Throwable)cnf);
        }
        catch (NoSuchMethodException nsm) {
            throw new CallbackFailedPermanentlyException((Throwable)nsm);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        return result;
    }

    private String getStringResultOfMethod(Object adminServiceObj, String methodToCallStr) throws CallbackFailedPermanentlyException {
        Class<?> adminServiceClass = adminServiceObj.getClass();
        if (adminServiceClass == null) {
            return null;
        }
        Method methodToCall = null;
        try {
            methodToCall = adminServiceClass.getMethod(methodToCallStr, new Class[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (methodToCall == null || Modifier.isStatic(methodToCall.getModifiers())) {
            throw new CallbackFailedPermanentlyException((ILocalizableMessage)new LocalizedMessage(this.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Admin_Service_Get_Info_Method_Not_Found_Message", methodToCallStr)));
        }
        Object result = null;
        try {
            result = methodToCall.invoke(adminServiceObj, new Object[0]);
        }
        catch (Exception e) {
            throw new CallbackFailedPermanentlyException((Throwable)e);
        }
        if (result == null) {
            return null;
        }
        return (String)result;
    }
}

