/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.beans;

import com.wily.introscope.agent.beans.AAgentRemoteBean;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.util.INameChangeListener;

public abstract class AAgentBeanNameListener
implements INameChangeListener {
    AAgentRemoteBean fBean;
    Class fServiceClass;

    public AAgentBeanNameListener(AAgentRemoteBean bean, Class serviceClass) {
        this.fBean = bean;
        this.fServiceClass = serviceClass;
    }

    protected void executeOnNameChanged(String newName) {
        try {
            if (this.fBean.getQualifiedAgentName() != null) {
                this.fBean.destroyMessageServiceFromListener(this.fServiceClass);
            }
            this.fBean.setQualifiedAgentName(this.fBean.getAgentHost() + "|" + this.fBean.getAgentProcess() + "|" + newName);
            this.fBean.getAgent().IAgent_getModuleFeedback().verbose("Registering " + this.fBean + " for new agent name : " + this.fBean.getQualifiedAgentName());
            this.fBean.createMessageServiceFromListener(this.fServiceClass, this.fBean.getQualifiedAgentName(), new String[]{"Workstation", "Server"});
        }
        catch (EntryAlreadyExistsException e) {
            this.fBean.getAgent().IAgent_getModuleFeedback().verbose("Failed to re-register " + this.fBean + " on Agent name change event.");
        }
        catch (Exception e) {
            this.fBean.getAgent().IAgent_getModuleFeedback().warn("Failed to re-register " + this.fBean + " on Agent name change event.");
            this.fBean.getAgent().IAgent_getModuleFeedback().debug("Failed to re-register " + this.fBean + " on Agent name change event.", e);
        }
    }
}

