/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.autoprobe;

import com.wily.introscope.api.autoprobe.AutoProbeCreationFailedException;
import com.wily.introscope.api.autoprobe.IntroscopeAutoProbe;
import com.wily.introscope.api.autoprobe.IntroscopeAutoProbeImpl;
import java.util.Hashtable;

public abstract class IntroscopeAutoProbeFactory {
    public static final String DISABLE = "DISABLE";
    public static final String RETURN_NULL_ON_NO_CHANGE = "RETURN_NULL_ON_NO_CHANGE";
    public static final String USE_SYSTEM_ERROR_ONLY = "USE_SYSTEM_ERROR_ONLY";
    public static final String REPORT_API_USAGE_ERRORS = "REPORT_API_USAGE_ERRORS";

    private IntroscopeAutoProbeFactory() {
    }

    private static boolean isDisabled(Hashtable parameters) {
        if (parameters != null) {
            return parameters.containsKey(DISABLE);
        }
        return false;
    }

    private static boolean shouldReturnNullOnNoChange(Hashtable parameters) {
        if (parameters != null) {
            return parameters.containsKey(RETURN_NULL_ON_NO_CHANGE);
        }
        return false;
    }

    private static boolean shouldUseSystemErrorOnly(Hashtable parameters) {
        if (parameters != null) {
            return parameters.containsKey(USE_SYSTEM_ERROR_ONLY);
        }
        return false;
    }

    private static boolean shouldReportAPIErrors(Hashtable parameters) {
        if (parameters != null) {
            return parameters.containsKey(REPORT_API_USAGE_ERRORS);
        }
        return false;
    }

    public static IntroscopeAutoProbe createIntroscopeAutoProbe(Hashtable parameters) throws AutoProbeCreationFailedException {
        try {
            boolean disabled = IntroscopeAutoProbeFactory.isDisabled(parameters);
            boolean returnNullOnNoChange = IntroscopeAutoProbeFactory.shouldReturnNullOnNoChange(parameters);
            boolean useSystemErrorOnly = IntroscopeAutoProbeFactory.shouldUseSystemErrorOnly(parameters);
            boolean reportAPIErrors = IntroscopeAutoProbeFactory.shouldReportAPIErrors(parameters);
            return new IntroscopeAutoProbeImpl(disabled, returnNullOnNoChange, useSystemErrorOnly, reportAPIErrors);
        }
        catch (Exception e) {
            throw new AutoProbeCreationFailedException(e.getMessage());
        }
    }
}

