/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.api.instrument.JavaRedefineRetransformBean;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class MiniJavaAgent {
    static volatile JavaRedefineRetransformBean status;
    static final ClassFileTransformer sTransformer;
    static final ClassFileTransformer nullTransformer;

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        System.out.println("Just called the agent. Parameters = " + agentArgs);
        status = JavaRedefineRetransformBean.getJavaRedefineRetransformBeanInfo(agentArgs, instrumentation);
        if (agentArgs != null && agentArgs.indexOf("addTransformer") >= 0) {
            MiniJavaAgent.addTransformer(instrumentation, status);
        }
    }

    private static boolean addTransformer(Instrumentation i, JavaRedefineRetransformBean status) {
        try {
            if (status.fCanRetransform && status.fSuggestRetransform) {
                JavaRedefineRetransformBean.info(status, "Try and add transformer that can retransform classes");
                Method instrumentationAddTransformer = i.getClass().getMethod("addTransformer", ClassFileTransformer.class, Boolean.TYPE);
                ClassFileTransformer t = status.fUseNullTransformer ? nullTransformer : sTransformer;
                instrumentationAddTransformer.invoke((Object)i, t, Boolean.TRUE);
                return true;
            }
        }
        catch (SecurityException e) {
            JavaRedefineRetransformBean.debug(status, "Unable to add class retransformer: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            JavaRedefineRetransformBean.debug(status, "Class retransformation not supported by JVM");
        }
        catch (IllegalArgumentException e) {
            JavaRedefineRetransformBean.debug(status, "Unable to add class retransformer: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            JavaRedefineRetransformBean.debug(status, "Unable to add class retransformer: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            JavaRedefineRetransformBean.debug(status, "Unable to add class retransformer: " + e.getMessage());
        }
        catch (ClassCastException e) {
            JavaRedefineRetransformBean.debug(status, "Unable to add class retransformer: " + e.getMessage());
        }
        JavaRedefineRetransformBean.info(status, "Try and add transformer using java5 API");
        ClassFileTransformer t = status.fUseNullTransformer ? nullTransformer : sTransformer;
        i.addTransformer(t);
        return false;
    }

    static {
        sTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    if (classfileBuffer != null) {
                        JavaRedefineRetransformBean.debug(status, "copying the bytes of class " + className);
                        byte[] newArray = new byte[classfileBuffer.length];
                        System.arraycopy(classfileBuffer, 0, newArray, 0, newArray.length);
                        return newArray;
                    }
                    JavaRedefineRetransformBean.debug(status, "Class " + className + " is null");
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        nullTransformer = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                try {
                    JavaRedefineRetransformBean.debug(status, "Doing nothing with " + className);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
    }
}

