/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.util.clock.MasterClock;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class GUIDGenerator {
    private static final Map<String, GUIDGenerator> instances = new HashMap<String, GUIDGenerator>();
    private final Random seeder;
    private final String hostAndSystemID;
    private final String hostAndSystemIDShort;
    static final char[] kcharsHexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String kstDefaultHost = "00000000";
    public static final String kDefaultSeeder = SecureRandom.class.getName();

    private GUIDGenerator() {
        this(new SecureRandom());
    }

    private GUIDGenerator(Random aSeeder) {
        byte[] addr;
        this.seeder = aSeeder;
        StringBuilder buffer = new StringBuilder(16);
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception exception) {
            addr = kstDefaultHost.getBytes();
        }
        buffer.append(GUIDGenerator.toHex(GUIDGenerator.toInt(addr), 8));
        buffer.append(GUIDGenerator.toHex(System.identityHashCode(this), 8));
        this.hostAndSystemID = buffer.toString();
        int hashCode = this.hostAndSystemID.hashCode();
        this.hostAndSystemIDShort = GUIDGenerator.toHex(hashCode & 0xFFFF, 4);
    }

    public static GUIDGenerator getInstance(String seederClassName) {
        GUIDGenerator instance = null;
        instance = instances.get(seederClassName);
        if (instance == null) {
            try {
                Random seeder = (Random)Class.forName(seederClassName).newInstance();
                instance = new GUIDGenerator(seeder);
                instances.put(seederClassName, instance);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static GUIDGenerator getInstance() {
        return GUIDGenerator.getInstance(kDefaultSeeder);
    }

    public String generateKey() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(GUIDGenerator.toHex((int)(MasterClock.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL), 8));
        buffer.append(this.hostAndSystemID);
        buffer.append(GUIDGenerator.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    public String generateShortKey() {
        StringBuilder buffer = new StringBuilder(16);
        buffer.append(GUIDGenerator.toHex((int)(MasterClock.currentTimeMillis() & 0xFFFFL), 4));
        buffer.append(this.hostAndSystemIDShort);
        buffer.append(GUIDGenerator.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    public static String toHex(int value, int length) {
        StringBuilder buffer = new StringBuilder(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(kcharsHexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            int b = bytes[i] & 0xFF;
            value |= b;
        }
        return value;
    }

    public boolean fromSameHost(String guidString) {
        String guidHostAndId = guidString.substring(8, 24);
        return guidHostAndId.equals(this.hostAndSystemID);
    }
}

