/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.bit;

public class BitPacking {
    static int[] kBitMask;
    private static final int[] kNumberOfBits;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        kBitMask = nArray;
        kNumberOfBits = new int[256];
        int shift = 1;
        int i = 0;
        while (i < 256) {
            if (i == 1 << shift) {
                // empty if block
            }
            BitPacking.kNumberOfBits[i] = ++shift;
            ++i;
        }
    }

    public static int bitLengthOfByte(int byteValue) {
        return kNumberOfBits[byteValue];
    }

    public static int bitLengthOfInt(int val) {
        int tmp = val >>> 24 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 24;
        }
        tmp = val >>> 16 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 16;
        }
        tmp = val >>> 8 & 0xFF;
        if (tmp != 0) {
            return kNumberOfBits[tmp] + 8;
        }
        tmp = val & 0xFF;
        return kNumberOfBits[tmp];
    }

    public static int bitLengthOfLong(long val) {
        int hiPart = (int)(val >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        if (hiPart != 0) {
            return BitPacking.bitLengthOfInt(hiPart) + 32;
        }
        int lowPart = (int)(val & 0xFFFFFFFFFFFFFFFFL);
        return BitPacking.bitLengthOfInt(lowPart);
    }

    public static int getIntBufferSize(int numBits) {
        return numBits + 31 >>> 5;
    }

    public static void writeBytes(int[] buf, int bitIndex, byte[] bytes) {
        int iter = 0;
        while (iter < bytes.length) {
            BitPacking.writeInt(buf, bitIndex, 8, (int)bytes[iter]);
            ++iter;
            bitIndex += 8;
        }
    }

    public static byte[] readBytes(int[] buf, int bitIndex, int numBytes) {
        byte[] bytes = new byte[numBytes];
        int iter = 0;
        while (iter < numBytes) {
            bytes[iter] = (byte)BitPacking.readInt(buf, bitIndex, 8);
            ++iter;
            bitIndex += 8;
        }
        return bytes;
    }

    public static void writeInt(int[] dst, int bitIndex, int bitLength, int paramVal) {
        int val = paramVal << 32 - bitLength;
        int arrayIndex = bitIndex >>> 5;
        dst[arrayIndex] = dst[arrayIndex] & ~(-1 << 32 - bitLength >>> (bitIndex &= 0x1F)) | val >>> bitIndex;
        if ((bitLength -= 32 - bitIndex) > 0) {
            dst[++arrayIndex] = dst[arrayIndex] & -1 >>> bitLength | val << 32 - bitIndex;
        }
    }

    public static void writeLong(int[] dst, int bitIndex, int bitLength, long val) {
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            BitPacking.writeInt(dst, bitIndex, numHighBits, (int)(val >>> 32));
            bitIndex += numHighBits;
            bitLength = 32;
        }
        BitPacking.writeInt(dst, bitIndex, bitLength, (int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static void writeInt(byte[] b, int bitIndex, int bitLength, int paramVal) {
        int val = paramVal << 32 - bitLength;
        int byteIndex = bitIndex >>> 3;
        int dstShift = bitIndex & 7;
        if (dstShift != 0) {
            b[byteIndex] = (byte)(b[byteIndex] | val >>> 24 + dstShift & 0xFF);
            ++byteIndex;
            bitLength -= 8 - dstShift;
            val <<= 8 - dstShift;
        }
        while (bitLength > 0) {
            int newValue = val >>> 24;
            b[byteIndex++] = (byte)(newValue & 0xFF);
            bitLength -= 8;
            val <<= 8;
        }
    }

    public static void writeLong(byte[] b, int bitIndex, int bitLength, long val) {
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            BitPacking.writeInt(b, bitIndex, numHighBits, (int)(val >>> 32));
            bitIndex += numHighBits;
            bitLength = 32;
        }
        BitPacking.writeInt(b, bitIndex, bitLength, (int)(val & 0xFFFFFFFFFFFFFFFFL));
    }

    public static int readInt(int[] src, int bitIndex, int bitLength) {
        int result;
        int arrayIndex = bitIndex >>> 5;
        int maxFirstLength = 32 - (bitIndex &= 0x1F);
        int firstLen = maxFirstLength < bitLength ? maxFirstLength : bitLength;
        try {
            result = src[arrayIndex] << bitIndex >>> 32 - firstLen;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.print("Index out of bounds: " + arrayIndex + "  Arraysize: " + src.length);
            throw e;
        }
        if ((bitLength -= firstLen) > 0) {
            result = result << bitLength | src[++arrayIndex] >>> 32 - bitLength;
        }
        return result;
    }

    public static int readInt(byte[] b, int bitIndex, int bitLength) {
        int newValue;
        int result = 0;
        int byteIndex = bitIndex >>> 3;
        int byteOffset = bitIndex & 7;
        if (byteOffset != 0) {
            int bitsToGet = 8 - byteOffset;
            newValue = b[byteIndex++] & kBitMask[bitsToGet];
            if (bitLength < bitsToGet) {
                newValue >>>= bitsToGet - bitLength;
                bitsToGet = bitLength;
            }
            result = newValue;
            bitLength -= bitsToGet;
        }
        while (bitLength > 8) {
            newValue = b[byteIndex++] & 0xFF;
            result = result << 8 | newValue;
            bitLength -= 8;
        }
        if (bitLength > 0) {
            newValue = (b[byteIndex] & 0xFF) >>> 8 - bitLength;
            result = result << bitLength | newValue;
        }
        return result;
    }

    public static long readLong(byte[] b, int bitIndex, int bitLength) {
        long result = 0L;
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            int hiVal = BitPacking.readInt(b, bitIndex, numHighBits);
            result = (long)hiVal << 32;
            bitIndex += numHighBits;
            bitLength = 32;
        }
        return result |= (long)BitPacking.readInt(b, bitIndex, bitLength) & 0xFFFFFFFFL;
    }

    public static long readLong(int[] dst, int bitIndex, int bitLength) {
        long result = 0L;
        if (bitLength > 32) {
            int numHighBits = bitLength - 32;
            int hiVal = BitPacking.readInt(dst, bitIndex, numHighBits);
            result = (long)hiVal << 32;
            bitIndex += numHighBits;
            bitLength = 32;
        }
        return result |= (long)BitPacking.readInt(dst, bitIndex, bitLength) & 0xFFFFFFFFL;
    }

    public static boolean bitRangeIsZero(int[] src, int bitIndex, int bitLength) {
        int arrayIndex = bitIndex >>> 5;
        int lastValidBit = bitIndex + bitLength - 1;
        int lastValidIndex = lastValidBit >>> 5;
        lastValidBit &= 0x1F;
        long bitMask = (2L << 31 - (bitIndex &= 0x1F)) - 1L;
        if (arrayIndex == lastValidIndex) {
            bitMask &= (1L << 31 - lastValidBit) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((src[arrayIndex] & (int)bitMask) != 0) {
            return false;
        }
        if (arrayIndex < lastValidIndex) {
            while (++arrayIndex < lastValidIndex) {
                if (src[arrayIndex] == 0) continue;
                return false;
            }
            if ((src[arrayIndex] & (int)((1L << 31 - lastValidBit) - 1L ^ 0xFFFFFFFFFFFFFFFFL)) != 0) {
                return false;
            }
        }
        return true;
    }

    public static int packLong(byte[] dst, int bitIndex, long value) {
        if (value == 0L || value == 1L) {
            BitPacking.writeInt(dst, bitIndex, 2, (int)value << 1 | 1);
            return 2;
        }
        int msbOfValue = 1;
        long tmpVal = value;
        while ((tmpVal >>>= 1) != 0L) {
            ++msbOfValue;
        }
        int msbOfMSB = 0;
        int tmpMSB = msbOfValue;
        while ((tmpMSB >>>= 1) != 0) {
            ++msbOfMSB;
        }
        BitPacking.writeLong(dst, bitIndex, msbOfMSB, 0L);
        bitIndex += msbOfMSB;
        BitPacking.writeLong(dst, bitIndex, ++msbOfMSB, (long)msbOfValue);
        BitPacking.writeLong(dst, bitIndex += msbOfMSB, --msbOfValue, value & (1L << msbOfValue ^ 0xFFFFFFFFFFFFFFFFL));
        return (msbOfMSB << 1) - 1 + msbOfValue;
    }

    public static long unpackLong(byte[] dst, int[] bitIndexCBR) {
        int bitIndex = bitIndexCBR[0];
        int msbOfMSB = 0;
        while (BitPacking.readLong(dst, bitIndex++, 1) == 0L) {
            ++msbOfMSB;
        }
        if (msbOfMSB == 0) {
            bitIndexCBR[0] = bitIndex + 1;
            return BitPacking.readLong(dst, bitIndex, 1);
        }
        int msbOfValue = (int)(1L << msbOfMSB | BitPacking.readLong(dst, bitIndex, msbOfMSB)) - 1;
        bitIndexCBR[0] = (bitIndex += msbOfMSB) + msbOfValue;
        return 1L << msbOfValue | BitPacking.readLong(dst, bitIndex, msbOfValue);
    }

    public static void writeLong(long[] dst, long bitIndex, int bitLength, long val) {
        int arrayIndex = (int)(bitIndex >>> 6);
        int bitNo = (int)bitIndex & 0x3F;
        int n = arrayIndex;
        dst[n] = dst[n] | val << bitNo;
        if (bitLength + bitNo > 64) {
            int n2 = arrayIndex + 1;
            dst[n2] = dst[n2] | val >>> 64 - bitNo;
        }
    }

    public static long readLong(byte[] dst, long bitIndex, int bitLength) {
        int arrayIndex = (int)(bitIndex >>> 6);
        int bitNo = (int)bitIndex & 0x3F;
        long result = 0L;
        int leftoverBits = bitLength + bitNo - 64;
        if (leftoverBits > 0) {
            result = ((long)dst[arrayIndex + 1] & (1L << leftoverBits) - 1L) << 64 - bitNo;
        }
        return result | (long)dst[arrayIndex] & (1L << bitLength) - 1L;
    }
}

