/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

class PrefixedKeysIterator
implements Iterator<String> {
    private final Iterator<String> iterator;
    private final String keyPrefix;
    private String nextElement;
    private boolean hasKey;
    private boolean caseSensitiveCompare;

    public PrefixedKeysIterator(Iterator<String> mainIterator, String keyPrefix, boolean caseSensitiveCompare) {
        this.iterator = mainIterator;
        this.caseSensitiveCompare = caseSensitiveCompare;
        this.keyPrefix = !caseSensitiveCompare && keyPrefix != null ? keyPrefix.toLowerCase(Locale.US) : keyPrefix;
    }

    @Override
    public boolean hasNext() {
        return this.hasKey || this.setNextElement();
    }

    @Override
    public String next() {
        if (!this.hasKey && !this.setNextElement()) {
            throw new NoSuchElementException();
        }
        this.hasKey = false;
        return this.nextElement;
    }

    @Override
    public void remove() {
    }

    private boolean setNextElement() {
        while (this.keyPrefix != null && this.iterator != null && this.iterator.hasNext()) {
            String key = this.iterator.next();
            if (key == null || key.length() <= this.keyPrefix.length() || !(this.caseSensitiveCompare ? key.trim().startsWith(this.keyPrefix) : key.toLowerCase(Locale.US).trim().startsWith(this.keyPrefix))) continue;
            this.nextElement = key;
            this.hasKey = true;
            return true;
        }
        return false;
    }
}

