/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class InstrumentationDelegate {
    private static final char kDotSeparator = '.';
    private static final char kJarSeparator = '/';
    private static final String kClassExtension = ".class";
    private static final String kDynamicInstrumentBehaviorName = "Introscope Dynamic Instrumentation Behavior";
    public static final String kDynamicInstrumentationPollingInterval = "introscope.autoprobe.dynamicinstrument.pollIntervalMinutes";
    public static final String kDynamicInstrumentationEnabled = "introscope.autoprobe.dynamicinstrument.enabled";
    public static final String kAvoidClassLoaderList = "introscope.autoprobe.dynamicinstrument.avoidClassLoaders";
    public static final String kInstrumentClassesList = "introscope.autoprobe.dynamicinstrument.instrumentList";
    public static final String kClassFileSizeLimit = "introscope.autoprobe.dynamicinstrument.classFileSizeLimitInMegs";
    public static final String kInstrumentAll = "all";
    public static final String kSystemLoaderStr = "System";
    private long kBehaviorInterval = 60000L;
    private final IAgent fAgent;
    private final IDynamicInstrumentationTransformer fTransformer;
    private final IAutoProbeConfig fAutoProbe;
    private final Instrumentation fInstrumentation;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IntervalHeartbeat fHeartbeat;
    private Set fAvoidClassLoaderSet;
    private Set fInstrumentSet;
    private boolean fRedefineAll;
    private boolean fRedefineNone;
    private boolean fFilterValueChanged;
    private volatile boolean fRedefinitionInProgress;
    private String fFilterValue;
    private boolean fAvoidSystemClassLoader;
    private int fClassFileSizeLimit;
    private DGCompilerSettings fCompilerSettings;

    public InstrumentationDelegate(IAgent agent, IDynamicInstrumentationTransformer transformer, ICompilerLogger logger, IAutoProbeConfig configRepository, Instrumentation instrumentation) {
        System.out.println("Constructing Instrumentation delegate");
        this.fAgent = agent;
        this.fTransformer = transformer;
        this.fAutoProbe = configRepository;
        this.fInstrumentation = instrumentation;
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fLocalizer = this.fAgent.IAgent_getStringLocalizer();
        this.fHeartbeat = this.fAgent.IAgent_getConfigHeartbeat();
        this.fAvoidClassLoaderSet = new HashSet();
        this.fInstrumentSet = new HashSet();
        if (this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(kDynamicInstrumentationEnabled, false)) {
            System.out.println("Instrumentation delegate is active");
            long pollingInterval = this.fAgent.IAgent_getIndexedProperties().getLongProperty(kDynamicInstrumentationPollingInterval);
            if (pollingInterval > 0L) {
                this.kBehaviorInterval = pollingInterval * 60L * 1000L;
            }
            this.fFeedback.debug("Dynamic Instrument Polling interval set to :" + this.kBehaviorInterval / 60000L + "minutes");
            this.fCompilerSettings = this.fAutoProbe.getCompilerSettings();
            this.fFilterValue = this.fAgent.IAgent_getIndexedProperties().getProperty(kInstrumentClassesList, "");
            this.setFilterOptions();
            agent.addConfigurationListener(new IConfigurationListener(){

                public void onChange(IndexedProperties newProps) {
                    if (!newProps.getProperty(InstrumentationDelegate.kInstrumentClassesList, "").equals(InstrumentationDelegate.this.fFilterValue)) {
                        InstrumentationDelegate.this.fFilterValue = newProps.getProperty(InstrumentationDelegate.kInstrumentClassesList, "");
                        InstrumentationDelegate.this.setFilterOptions();
                        InstrumentationDelegate.this.fFilterValueChanged = true;
                    }
                }
            });
            this.readClassLoaderList(this.fAgent.IAgent_getIndexedProperties());
            this.fClassFileSizeLimit = this.fAgent.IAgent_getIndexedProperties().getIntProperty(kClassFileSizeLimit, 1) * 512;
            this.registerHeartBeat();
        } else {
            this.fFeedback.debug("Dynamic Instrumentation is turned off");
            System.out.println("Instrumentation delegate is not active");
        }
        new Exception().printStackTrace();
    }

    private void registerHeartBeat() {
        if (!this.fInstrumentation.isRedefineClassesSupported()) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Dynamic_Instrumentation_Disabled", ""));
        } else {
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Dynamic_Instrumentation_Enabled", ""));
            DirectivesSyncBehavior directivesBehavior = new DirectivesSyncBehavior();
            this.fHeartbeat.addBehavior((ITimestampedRunnable)directivesBehavior, kDynamicInstrumentBehaviorName, true, this.kBehaviorInterval, false);
        }
    }

    private void readClassLoaderList(IndexedProperties properties) {
        String classLoaderList = properties.getProperty(kAvoidClassLoaderList, "");
        if (!classLoaderList.equals("")) {
            StringTokenizer st = new StringTokenizer(classLoaderList, ",");
            while (st.hasMoreTokens()) {
                String classLoader = st.nextToken();
                if (kSystemLoaderStr.equalsIgnoreCase(classLoader)) {
                    this.fAvoidSystemClassLoader = true;
                    continue;
                }
                this.fFeedback.debug("adding class loader to the avoid list " + classLoader);
                this.fAvoidClassLoaderSet.add(classLoader);
            }
        }
    }

    private void setFilterOptions() {
        this.fRedefineAll = false;
        this.fRedefineNone = false;
        if (kInstrumentAll.equals(this.fFilterValue)) {
            this.fRedefineAll = true;
        }
        if (this.fFilterValue == null || "".equals(this.fFilterValue)) {
            this.fRedefineNone = true;
        } else if (!this.fRedefineAll) {
            this.readInstrumentList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInstrumentList() {
        Set set = this.fInstrumentSet;
        synchronized (set) {
            if (!this.fFilterValue.equals("")) {
                StringTokenizer st = new StringTokenizer(this.fFilterValue, ",");
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    this.fFeedback.debug("adding to the instrument list " + str);
                    if (kInstrumentAll.equals(str)) {
                        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Cannot_Use_All_With_Other_Filters", ""));
                        continue;
                    }
                    this.fInstrumentSet.add(str);
                }
            }
        }
    }

    private boolean monitorFilterValue() {
        if (this.fFilterValueChanged) {
            this.fFilterValueChanged = false;
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Detected_Changed_Filter", ""));
            return true;
        }
        return false;
    }

    private boolean syncDirectives() {
        this.fFeedback.debug("Syncing up directives");
        if (this.fAutoProbe.getCompilerSettings() == this.fCompilerSettings) {
            this.fFeedback.debug("Compiler Settings did not change");
            return false;
        }
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Detected_Changed_Directives", ""));
        this.fFeedback.debug("Compiler Settings changed");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefineAllClasses() {
        this.fFeedback.debug("redefining classes");
        this.fRedefinitionInProgress = true;
        if (this.fRedefineNone) {
            this.fCompilerSettings = this.fAutoProbe.getCompilerSettings();
            this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Nothing_Redefined", ""));
            return;
        }
        Class[] classes = this.fInstrumentation.getAllLoadedClasses();
        try {
            for (int i = 0; i < classes.length; ++i) {
                boolean redefine;
                Class cls = classes[i];
                boolean bl = redefine = this.redefine(cls, this.fAutoProbe.getCompilerSettings()) && this.passesFilter(cls);
                if (!redefine) continue;
                this.redefineClass(cls);
            }
        }
        catch (Exception e) {
            this.fFeedback.debug((Throwable)e);
        }
        finally {
            this.fCompilerSettings = this.fAutoProbe.getCompilerSettings();
            this.fRedefinitionInProgress = false;
            this.fTransformer.redefinitionComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean passesFilter(Class cls) {
        if (this.fRedefineAll) {
            return true;
        }
        Set set = this.fInstrumentSet;
        synchronized (set) {
            for (String packageFormat : this.fInstrumentSet) {
                if (!cls.getName().startsWith(packageFormat)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean redefine(Class cls, DGCompilerSettings newSettings) {
        if (cls.getClassLoader() == null) {
            return false;
        }
        if (cls.isArray()) {
            return false;
        }
        if (cls.isInterface()) {
            return false;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("com.sun") || cls.getName().startsWith("sun.reflect") || cls.getName().startsWith("$")) {
            return false;
        }
        if (this.fAvoidSystemClassLoader && cls.getClassLoader() == ClassLoader.getSystemClassLoader()) {
            return false;
        }
        if (this.fCompilerSettings.getFilter().shouldSkip(cls.getName()) && newSettings.getFilter().shouldSkip(cls.getName())) {
            return false;
        }
        return !this.fAvoidClassLoaderSet.contains(cls.getClassLoader().getClass().getName());
    }

    private void redefineClass(Class cls) {
        byte[] classBytes = null;
        try {
            classBytes = this.getBytesForClass(cls);
            if (classBytes != null) {
                ClassDefinition classDef = new ClassDefinition(cls, classBytes);
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("Redefining class -" + cls.getName());
                }
                this.fInstrumentation.redefineClasses(classDef);
            }
        }
        catch (ClassNotFoundException e) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), (Throwable)e);
        }
        catch (UnmodifiableClassException e) {
            this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Class_Redefine_Failed", ""), (Throwable)e);
        }
        catch (IOException e) {
            this.fFeedback.debug("Could not obtain class bytes for the class -" + cls.getName(), (Throwable)e);
        }
        catch (Throwable e) {
            this.fFeedback.debug("Re-define failed for class-" + cls.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesForClass(Class cls) throws IOException {
        this.fFeedback.debug("getting bytes for class -" + cls.getName());
        InputStream is = null;
        ClassLoader classLoader = cls.getClassLoader();
        String path = cls.getName().replace('.', '/') + kClassExtension;
        this.fFeedback.debug("searching for path -" + path);
        try {
            byte[] classBytes;
            is = classLoader.getResourceAsStream(path);
            if (is == null) {
                throw new IOException("input stream null");
            }
            byte[] byArray = classBytes = this.getBytesForClass(is);
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesForClass(InputStream is) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] byteArray = new byte[2048];
            int counter = 0;
            int i = is.read(byteArray);
            while (i > 0) {
                if (counter > this.fClassFileSizeLimit) {
                    this.fFeedback.debug("Cannot read Class File bigger than configured size - " + this.fClassFileSizeLimit / 512 + "MB");
                    byte[] byArray = null;
                    return byArray;
                }
                baos.write(byteArray, 0, i);
                ++counter;
                i = is.read(byteArray);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        byte[] retArray = baos.toByteArray();
        this.fFeedback.trace("returning byte array of length ->" + retArray.length);
        return retArray;
    }

    private final class DirectivesSyncBehavior
    implements ITimestampedRunnable {
        private DirectivesSyncBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (InstrumentationDelegate.this.fRedefinitionInProgress) {
                return;
            }
            boolean needRedefineFromFilter = InstrumentationDelegate.this.monitorFilterValue();
            boolean needRedefineFromSettings = InstrumentationDelegate.this.syncDirectives();
            if (needRedefineFromFilter || needRedefineFromSettings) {
                InstrumentationDelegate.this.redefineAllClasses();
            }
        }
    }
}

