/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.exitpoint;

import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.detection.RecordingData;
import com.wily.introscope.agent.intelligent.exitpoint.stacktrace.WrappedStackTrace;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class ExitPointRecordingData
extends RecordingData {
    private final Queue<WrappedStackTrace> queue = new ConcurrentLinkedQueue<WrappedStackTrace>();
    private final AtomicReference<StackTraceElement[]> lastCapturedTrace = new AtomicReference();

    public WrappedStackTrace[] harvest() {
        WrappedStackTrace[] array = null;
        if (!this.queue.isEmpty()) {
            array = this.queue.toArray(new WrappedStackTrace[this.queue.size()]);
            this.queue.clear();
        }
        this.lastCapturedTrace.set(null);
        return array;
    }

    public int getStorageSize() {
        return this.queue.size();
    }

    @Override
    public boolean acceptTrace(StackTraceElement[] trace) {
        IStackElement element = VirtualStack.peek();
        if (element instanceof InvocationData) {
            this.lastCapturedTrace.set(trace);
            return this.queue.add(new WrappedStackTrace(((InvocationData)element).getInvocationId(), trace));
        }
        return false;
    }

    @Override
    public StackTraceElement[] getTrace() {
        return this.lastCapturedTrace.get();
    }
}

