/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.jvm17;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.gcmonitor.instrumentation.ApplicationException;
import com.wily.introscope.gcmonitor.instrumentation.Collector;
import com.wily.introscope.gcmonitor.instrumentation.CollectorFactory;
import com.wily.introscope.gcmonitor.instrumentation.GCStatsUtils;
import com.wily.introscope.gcmonitor.ui.Messages;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.math.RunningLongAverage;
import com.wily.util.feedback.Module;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class GCListenerMemoryCollector
implements NotificationListener,
Collector {
    private static final Module module = new Module("GCMonitor");
    private static final IAgent agent = CollectorFactory.agent;
    private final GarbageCollectorMXBean collectorMXBean;
    private final MemoryMXBean memoryMXBean;
    private final AtomicLong reclaimedMemory = new AtomicLong();
    private final AtomicReference<RunningLongAverage> runningAverageRef = new AtomicReference<RunningLongAverage>(new RunningLongAverage());
    private final ILongIntervalCounterDataAccumulator memoryReclaimedAcc;
    private final IIntegerAverageDataAccumulator percentageHeapAcc;
    private final Set<String> heapPoolNames;

    public GCListenerMemoryCollector(GarbageCollectorMXBean bean, Set<String> heapPoolNames) {
        this.collectorMXBean = bean;
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.heapPoolNames = heapPoolNames;
        if (this.collectorMXBean instanceof NotificationEmitter) {
            String metricPrefix = GCListenerMemoryCollector.getMetricPrefix(bean.getName());
            DataAccumulatorFactory daf = agent.IAgent_getDataAccumulatorFactory();
            this.memoryReclaimedAcc = daf.safeGetLongIntervalCounterDataAccumulator(metricPrefix + GCListenerMemoryCollector.getString("GCMonitorTypeViewer.MemoryReclaimed"));
            this.percentageHeapAcc = daf.safeGetIntegerPercentageDataAccumulator(metricPrefix + GCListenerMemoryCollector.getString("GCMonitorTypeViewer.PercentageAfterGC"));
        } else {
            agent.IAgent_getModuleFeedback().debug(module, "Collector '" + this.collectorMXBean.getName() + "' does not support notifications. 'Memory Reclaimed' and 'Percentage Heap After GC' metrics won't be reported");
            this.memoryReclaimedAcc = null;
            this.percentageHeapAcc = null;
        }
    }

    @Override
    public boolean init() {
        return this.addListener();
    }

    protected boolean addListener() {
        if (this.memoryReclaimedAcc != null) {
            try {
                agent.IAgent_getModuleFeedback().debug(module, "Adding GC event notification listener with Collector '" + this.collectorMXBean.getName() + "'");
                NotificationEmitter notifier = (NotificationEmitter)((Object)this.collectorMXBean);
                notifier.addNotificationListener(this, null, null);
                return true;
            }
            catch (Exception e) {
                agent.IAgent_getModuleFeedback().error(module, "Unable to add GC event notification listener", (Throwable)e);
            }
        }
        return false;
    }

    protected void removeListener() {
        try {
            agent.IAgent_getModuleFeedback().debug(module, "Removing GC event notification listener from Collector '" + this.collectorMXBean.getName() + "'");
            NotificationEmitter notifier = (NotificationEmitter)((Object)this.collectorMXBean);
            notifier.removeNotificationListener(this);
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().error(module, "Unable to remove GC event notification listener", (Throwable)e);
        }
    }

    @Override
    public void publishMetricValues() {
        RunningLongAverage currentAvg;
        long memory = this.reclaimedMemory.getAndSet(0L);
        if (memory > 0L) {
            this.memoryReclaimedAcc.ILongAggregatingDataAccumulator_recordDataPoint(memory);
        }
        if ((currentAvg = (RunningLongAverage)this.runningAverageRef.getAndSet(null)) != null && currentAvg.getCount() > 0L) {
            this.percentageHeapAcc.IIntegerAggregatingDataAccumulator_recordDataPoint((int)currentAvg.getSafeAverage());
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("com.sun.management.gc.notification")) {
            GarbageCollectionNotificationInfo notice = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
            boolean traceEnabled = agent.IAgent_getModuleFeedback().isTraceEnabled(module);
            boolean debugEnabled = agent.IAgent_getModuleFeedback().isDebugEnabled(module);
            if (debugEnabled) {
                agent.IAgent_getModuleFeedback().debug(module, "Received GC event notification:" + this.toString(notice));
            }
            Map<String, MemoryUsage> before = notice.getGcInfo().getMemoryUsageBeforeGc();
            long reclaimed = 0L;
            if (traceEnabled) {
                agent.IAgent_getModuleFeedback().trace(module, "Memory usage before GC event: " + before);
                agent.IAgent_getModuleFeedback().trace(module, "Memory usage after GC event: " + notice.getGcInfo().getMemoryUsageAfterGc());
            }
            for (Map.Entry<String, MemoryUsage> entry : notice.getGcInfo().getMemoryUsageAfterGc().entrySet()) {
                if (!this.heapPoolNames.contains(entry.getKey())) continue;
                long diff = before.get(entry.getKey()).getUsed() - entry.getValue().getUsed();
                reclaimed += diff;
                if (!traceEnabled) continue;
                agent.IAgent_getModuleFeedback().trace(module, "Memory difference for pool " + entry.getKey() + " = " + diff + " (bytes)");
            }
            if (debugEnabled) {
                agent.IAgent_getModuleFeedback().debug(module, "Total memory reclaimed:  " + reclaimed + " (bytes)");
            }
            if (reclaimed > 0L) {
                this.reclaimedMemory.addAndGet(reclaimed);
            }
            int per = GCStatsUtils.getPercentageOfMemoryUsed(this.memoryMXBean.getHeapMemoryUsage());
            RunningLongAverage ra = this.runningAverageRef.getAndSet(null);
            if (ra == null) {
                ra = new RunningLongAverage();
            }
            ra.combineValue((long)per);
            this.runningAverageRef.set(ra);
        }
    }

    private static String getMetricPrefix(String gcAlgorithmName) {
        String rootNode = GCListenerMemoryCollector.getString("GCMonitorTypeViewer.RootNode");
        return rootNode + "|" + GCListenerMemoryCollector.getString("GCMonitorTypeViewer.CollectorsNode") + "|" + gcAlgorithmName + ":";
    }

    @Override
    public void turnOffMetrics(DataAccumulatorFactory factory) throws ApplicationException {
        this.removeListener();
        ArrayList<String> metricsTobeRemoved = new ArrayList<String>();
        metricsTobeRemoved.add(this.memoryReclaimedAcc.IDataAccumulator_getMetric().getAttributeURL());
        metricsTobeRemoved.add(this.percentageHeapAcc.IDataAccumulator_getMetric().getAttributeURL());
        for (String metric : metricsTobeRemoved) {
            try {
                factory.removeMetric(metric);
            }
            catch (BadlyFormedNameException e) {
                throw new ApplicationException(e);
            }
            catch (MetricNotFoundException e) {
                throw new ApplicationException(e);
            }
        }
    }

    private static String getString(String key) {
        return Messages.getString(key);
    }

    private String toString(GarbageCollectionNotificationInfo notification) {
        return "[name = " + notification.getGcName() + ", action = " + notification.getGcAction() + ", cause = " + notification.getGcCause() + ", gcInfo = " + this.toString(notification.getGcInfo()) + "]";
    }

    private String toString(GcInfo info) {
        return "(id = " + info.getId() + ", startTime =" + info.getStartTime() + ", endTime = " + info.getEndTime() + ", duration = " + info.getDuration() + ")";
    }
}

