/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpURLConnectionDataResolver;
import com.wily.introscope.agent.trace.backend.http.tracer.HttpURLConnectionBackendTracer;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;

public class HttpClientProbeBackendTracer
extends HttpURLConnectionBackendTracer {
    private static Module module = new Module("ProbeHttpClientBackendTracer");

    public HttpClientProbeBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object tracedObject) {
        super(agent, parameters, probe, tracedObject);
    }

    @Override
    public HttpDataResolver getDataResolver() {
        return ProbeHttpClientDataResolver.getInstance();
    }

    private static class ProbeHttpClientDataResolver
    implements HttpDataResolver {
        private final HttpDataResolver delegate;
        private static final HttpDataResolver instance = new ProbeHttpClientDataResolver(HttpURLConnectionDataResolver.getInstance());

        private ProbeHttpClientDataResolver(HttpDataResolver delegate) {
            this.delegate = delegate;
        }

        public static HttpDataResolver getInstance() {
            return instance;
        }

        @Override
        public URI getUri(IAgent agent, InvocationData data) {
            return this.delegate.getUri(agent, data);
        }

        @Override
        public String getHttpMethod(IAgent agent, InvocationData data) {
            return this.delegate.getHttpMethod(agent, data);
        }

        @Override
        public int getHttpStatusCode(IAgent agent, InvocationData data) {
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            try {
                return connection.getResponseCode();
            }
            catch (IOException e) {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusCode() Unable to get response code: " + e.toString());
                agent.IAgent_getModuleFeedback().verbose((Throwable)e);
                return -1;
            }
        }

        @Override
        public String getHttpStatusMessage(IAgent agent, InvocationData data) {
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            try {
                return connection.getResponseMessage();
            }
            catch (IOException e) {
                agent.IAgent_getModuleFeedback().error(module, "getHttpStatusMessage() Unable to get response status message: " + e.toString());
                agent.IAgent_getModuleFeedback().verbose((Throwable)e);
                return null;
            }
        }
    }
}

