/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.net.URLClassLoader;

public class SAP71DeploymentTracer
extends ASingleInstanceTracerFactory {
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private IAgent agent = null;
    private IModuleFeedbackChannel logger = null;
    private String agentHome = null;

    public SAP71DeploymentTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.agentHome = WSMUtils.getAbsoluteAgentPath();
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int index, InvocationData invocationData) {
    }

    public void ITracer_finishTrace(int index, InvocationData invocationData) {
        ClassLoader parent = null;
        Object wsCl = null;
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Start In SAP71DeploymentTracer:ITracer_finishTrace");
            this.logger.debug("agentHome:" + this.agentHome);
        }
        try {
            Object wsContainer = invocationData.getInvocationObject();
            if (wsContainer != null) {
                parent = invocationData.getInvocationObject().getClass().getClassLoader();
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("The classloader of WebserviceRuntime:" + parent);
                }
                URLClassLoader wilyCL = WSMUtils.createClassLoader(parent, "WebServicesAgent.jar", this.getAgent());
                WSMUtils.setWilyClassLoader(wilyCL);
                Object runtimeProcessingEnv = invocationData.getInvocationObject();
                Object serviceContext = invocationData.getInvocationParameterAsObject(0);
                Object wsServiceContext = invocationData.getInvocationParameterAsObject(1);
                String strWSDMProviderProtocol = "com.wily.powerpack.webservices.handlers.netweaver.server.WSDMProviderProtocol";
                Class<?> wsdmProtocolProvider = Class.forName(strWSDMProviderProtocol, true, wilyCL);
                this.logger.debug("Created WSDMProviderProtocol");
                Class<Object> objectClz = Object.class;
                Method registerWilyProtocolProvider = wsdmProtocolProvider.getDeclaredMethod("registerWilyProtocolProvider", objectClz, objectClz, objectClz);
                Object wsdmProviderProtocol = registerWilyProtocolProvider.invoke(null, runtimeProcessingEnv, serviceContext, wsServiceContext);
                WSMUtils.setWsdmProviderProtocol(wsdmProviderProtocol);
                this.logger.info("Registered WSDMProviderProtocol");
                String strNW71JAXWSClientProtocol = "com.wily.powerpack.webservices.handlers.netweaver.client.NW71JAXWSClientProtocol";
                Class<?> wsdmClientProtocolClz = Class.forName(strNW71JAXWSClientProtocol, true, wilyCL);
                Method getInstanceMethod = wsdmClientProtocolClz.getDeclaredMethod("getInstanceMethod", objectClz, objectClz, objectClz);
                Object wsdmClientProtocol = getInstanceMethod.invoke(null, runtimeProcessingEnv, serviceContext, wsServiceContext);
                WSMUtils.setWsdmClientProtocol(wsdmClientProtocol);
                this.logger.info("Registered NW71JAXWSClientProtocol");
                String strNW71JAXRPCClientProtocol = "com.wily.powerpack.webservices.handlers.netweaver.client.WSDMClientProtocol";
                Class<?> wsdmClientRpcProtocolClz = Class.forName(strNW71JAXRPCClientProtocol, true, wilyCL);
                Method getRpcInstanceMethod = wsdmClientRpcProtocolClz.getDeclaredMethod("getInstanceMethod", objectClz, objectClz, objectClz);
                Object wsdmRpcClientProtocol = getRpcInstanceMethod.invoke(null, runtimeProcessingEnv, serviceContext, wsServiceContext);
                WSMUtils.setWsdmRpcClientProtocol(wsdmRpcClientProtocol);
                this.logger.info("Registered WSDMClientProtocol");
            }
        }
        catch (Throwable t) {
            StackTraceElement[] arr = t.getStackTrace();
            StringBuilder buf = new StringBuilder();
            for (int m = 0; m < arr.length; ++m) {
                buf.append(arr[m].toString() + "\n");
            }
            this.logger.error("Unable to add the JarResource: " + buf.toString());
            this.logger.error("Unable to add the JarResource: " + t);
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("End In SAP71DeploymentTracer:ITracer_finishTrace");
        }
    }
}

