/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ClientNameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;
    private static boolean isAxiom = false;

    public Axis2ClientNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ClientNameFormatter:: getServiceName");
        }
        Object call = null;
        try {
            call = data.getInvocationObject();
            if (call != null && (call = WSMUtils.invokeMethodOnObject(call, "getOptions")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getTo")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(call, "getAddress");
                serviceURI = WSMUtils.removeTrailingSlash(serviceURI);
            }
        }
        catch (Throwable bomb) {
            WSMUtils.handleException(this.getAgent(), "Axis2ClientNameFormatter getServiceName ", bomb);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Axis2ClientNameFormatter:: getServiceName serviceURI=" + serviceURI);
        }
        return serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object operationClient = data.getInvocationObject();
        Object messageContext = WSMUtils.invokeMethodOnObject(operationClient, "getMessageContext", new Class[]{String.class}, new Object[]{"Out"});
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Axis2ClientNameFormatter::getChild(data): soapBody=" + soapBody);
        }
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        namespaceURI = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        if (namespaceURI == null || "".equals(namespaceURI.trim())) {
            try {
                this.processInvocationData(data);
                namespaceURI = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
            }
            catch (Exception e) {
                WSMUtils.handleException(this.getAgent(), "Axis2ClientNameFormatter getNamespace2", e);
            }
        }
        return namespaceURI;
    }

    private void getNamespaceNOperationFromNextOMSibling(Object soapBody, InvocationData data) throws Exception {
        Object nextOMSibling = null;
        try {
            nextOMSibling = WSMUtils.invokeMethodOnObject(soapBody, "getNextOMSibling");
            String opName = (String)WSMUtils.invokeMethodOnObject(nextOMSibling, "getLocalName");
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)opName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: getNextOMSibling().getLocalName()= " + opName);
            }
            Object ns1 = WSMUtils.invokeMethodOnObject(nextOMSibling, "getNamespace");
            String ns = (String)WSMUtils.invokeMethodOnObject(ns1, "getNamespaceURI");
            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)ns);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: getNextOMSibling().getNamespace().getNamespaceURI() = " + ns);
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: getNextOMSibling class " + nextOMSibling.getClass().getCanonicalName());
                this.logger.trace("Axis2ClientNameFormatter :: getNextOMSibling " + nextOMSibling);
            }
            throw e;
        }
        isAxiom = true;
    }

    private void getNamespaceNOperationDirectFromChild(Object soapBody, InvocationData data) throws Exception {
        try {
            String operationName = (String)WSMUtils.invokeMethodOnObject(soapBody, "getLocalName");
            data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: getLocalName() = " + operationName);
            }
            Object qName = WSMUtils.invokeMethodOnObject(soapBody, "getQName");
            String namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespaceURI);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: getQName().getNamespaceURI() = " + namespaceURI);
            }
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ClientNameFormatter :: soapBody " + soapBody.getClass().getCanonicalName());
                this.logger.trace("Axis2ClientNameFormatter :: soapBody " + soapBody);
            }
            throw e;
        }
        isAxiom = false;
    }

    private void processInvocationData(InvocationData data) {
        try {
            Object child = this.getChild(data);
            if (child == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Axis2ClientNameFormatter::processInvocationData(data):  getChild(data) returns null; skip extracting namespace and operation info from SOAP object.");
                }
            } else if (!isAxiom) {
                try {
                    this.getNamespaceNOperationDirectFromChild(child, data);
                }
                catch (Exception e) {
                    this.getNamespaceNOperationFromNextOMSibling(child, data);
                }
            } else {
                try {
                    this.getNamespaceNOperationFromNextOMSibling(child, data);
                }
                catch (Exception e) {
                    this.getNamespaceNOperationDirectFromChild(child, data);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("Axis2ClientNameFormatter :: An exception occured while extracting SOAP message : " + e.getMessage());
            this.logger.debug((Throwable)e);
        }
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName == null || "".equals(operationName.trim())) {
            this.processInvocationData(data);
            operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        }
        return operationName;
    }
}

