/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.ICEMFilterListener;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.AFilterListTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.AndTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.CEMBusinessTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.OrTransactionTraceFilter;
import java.util.ArrayList;
import java.util.HashMap;

public class CEMFilterHelper
implements ICEMFilterListener,
IServerConnectionObserver {
    private static CEMFilterHelper kInstance = new CEMFilterHelper();
    private static HashMap kPublishedBTs = new HashMap();

    private CEMFilterHelper() {
    }

    public static CEMFilterHelper getInstance() {
        return kInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cemFilterCreated(CEMBusinessTransactionTraceFilter cemFilterInfo) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            Integer openBtSessions = (Integer)kPublishedBTs.get(cemFilterInfo.getBusinessTransactionName());
            openBtSessions = openBtSessions == null ? Integer.valueOf(1) : Integer.valueOf(openBtSessions + 1);
            kPublishedBTs.put(cemFilterInfo.getBusinessTransactionName(), openBtSessions);
        }
    }

    @Override
    public void cemFilterCreated(CEMBusinessTransactionTraceFilter[] cemFilterInfo) {
        for (int i = 0; i < cemFilterInfo.length; ++i) {
            this.cemFilterCreated(cemFilterInfo[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cemFilterRemoved(CEMBusinessTransactionTraceFilter cemFilter) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            Integer openBtSessions = (Integer)kPublishedBTs.get(cemFilter.getBusinessTransactionName());
            if (openBtSessions != null) {
                int count = openBtSessions;
                if (count == 1) {
                    kPublishedBTs.remove(cemFilter.getBusinessTransactionName());
                } else {
                    kPublishedBTs.put(cemFilter.getBusinessTransactionName(), count - 1);
                }
            }
        }
    }

    @Override
    public void cemFilterRemoved(CEMBusinessTransactionTraceFilter[] cemFilterInfo) {
        for (int i = 0; i < cemFilterInfo.length; ++i) {
            this.cemFilterRemoved(cemFilterInfo[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTraceRequestedFor(String btName) {
        HashMap hashMap = kPublishedBTs;
        synchronized (hashMap) {
            return kPublishedBTs.containsKey(btName);
        }
    }

    @Override
    public void agentControlAddTTFilter(ITransactionTraceFilter filter) {
        AndTransactionTraceFilter cemAndThresholdTransactionTraceFilter;
        CEMBusinessTransactionTraceFilter[] containedCEMFilterArray;
        if (filter instanceof AndTransactionTraceFilter && (containedCEMFilterArray = this.getContainedCEMFilters(cemAndThresholdTransactionTraceFilter = (AndTransactionTraceFilter)filter)) != null) {
            this.cemFilterCreated(containedCEMFilterArray);
        }
    }

    @Override
    public void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
        AndTransactionTraceFilter cemAndThresholdTransactionTraceFilter;
        CEMBusinessTransactionTraceFilter[] containedCEMFilterArray;
        if (filter instanceof AndTransactionTraceFilter && (containedCEMFilterArray = this.getContainedCEMFilters(cemAndThresholdTransactionTraceFilter = (AndTransactionTraceFilter)filter)) != null) {
            this.cemFilterRemoved(containedCEMFilterArray);
        }
    }

    @Override
    public void agentControlSetReportingState(boolean report) {
    }

    @Override
    public void agentControlStartReportingMetric(AgentMetric metric) {
    }

    @Override
    public void agentControlStopReportingMetric(AgentMetric metric) {
    }

    @Override
    public void serverConnected() {
    }

    @Override
    public void serverConnectionCycleFailed(int cycleCount) {
    }

    @Override
    public void serverDisconnected() {
    }

    public CEMBusinessTransactionTraceFilter[] getContainedCEMFilters(AndTransactionTraceFilter andCEMTransactionTraceFilter) {
        ArrayList<ITransactionTraceFilter> cemFilters = new ArrayList<ITransactionTraceFilter>();
        ITransactionTraceFilter[] fFilters = andCEMTransactionTraceFilter.getContainedTransactionFilters();
        for (int i = 0; i < fFilters.length; ++i) {
            int filterType = fFilters[i].ITransactionTraceFilter_getFilterType();
            if (CEMBusinessTransactionTraceFilter.getFilterType() == filterType) {
                cemFilters.add(fFilters[i]);
                return cemFilters.toArray(new CEMBusinessTransactionTraceFilter[0]);
            }
            if (OrTransactionTraceFilter.getFilterType() != filterType) continue;
            ITransactionTraceFilter[] filtersArray = ((AFilterListTransactionTraceFilter)fFilters[i]).getContainedTransactionFilters();
            for (int j = 0; j < filtersArray.length; ++j) {
                filterType = filtersArray[j].ITransactionTraceFilter_getFilterType();
                if (CEMBusinessTransactionTraceFilter.getFilterType() != filterType) continue;
                cemFilters.add(filtersArray[j]);
            }
            return cemFilters.toArray(new CEMBusinessTransactionTraceFilter[0]);
        }
        return null;
    }
}

