/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.HttpServletLazyMap;
import com.wily.introscope.agent.trace.hc2.HttpServletTracer;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Array;

public class HttpServletTracerWithAgentRoute
extends HttpServletTracer {
    public HttpServletTracerWithAgentRoute(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected String getPrefixForBtcMetrics(InvocationData data) {
        String routeKey = (String)data.get("!BRIDGE!");
        if (routeKey == null) {
            return "";
        }
        return "!BRIDGE!" + routeKey + "|";
    }

    @Override
    protected Object getBlameKey(InvocationData data) {
        if (this.fDoAppNaming && !sHaveGivenUpGettingCompName && data.getInvocationParameterCount() > 0) {
            if (!data.hasServletSupport()) {
                this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
            }
            InvocationData.ServletSupportClass support = data.getServletSupport();
            data.setServletSupportInTransactionCache(support);
            HttpServletLazyMap map = (HttpServletLazyMap)support.servletParametersMap;
            IBizTrx bixTrxKey = (IBizTrx)data.get("BusinessTrxData");
            if (bixTrxKey != null) {
                VirtualStack.getTransactionCache().setBizTrx(bixTrxKey);
            }
            Object requestURI = map.get("Normalized URL");
            Object serverPortAsInteger = map.getServerPortAsInteger();
            Object servletContext = map.getServletContext();
            Object synthTrxKey = map.getSyntheticTransactionName();
            String routeKey = (String)data.get("!BRIDGE!");
            int bpckLen = 2;
            int requestURIIndex = -1;
            int bizTrxKeyIndex = -1;
            int synthTrxKeyIndex = -1;
            int routeKeyIndex = -1;
            long bizTrxKeyId = -1L;
            if (requestURI != null) {
                requestURIIndex = bpckLen++;
            }
            if (bixTrxKey != null) {
                bizTrxKeyIndex = bpckLen++;
            }
            if (synthTrxKey != null) {
                synthTrxKeyIndex = bpckLen++;
            }
            if (routeKey != null) {
                routeKeyIndex = bpckLen++;
            }
            Object[] blameComponentKey = (Object[])Array.newInstance(Object.class, bpckLen);
            blameComponentKey[0] = servletContext;
            blameComponentKey[1] = serverPortAsInteger;
            if (requestURIIndex > 0) {
                blameComponentKey[requestURIIndex] = requestURI;
            }
            if (bizTrxKeyIndex > 0) {
                blameComponentKey[bizTrxKeyIndex] = bixTrxKey;
                bizTrxKeyId = bixTrxKey.getId();
            }
            if (synthTrxKeyIndex > 0) {
                blameComponentKey[synthTrxKeyIndex] = synthTrxKey;
            }
            if (routeKeyIndex > 0) {
                blameComponentKey[routeKeyIndex] = routeKey;
            }
            ABlameComponent key = ABlameComponent.getArrayInstance(blameComponentKey, bizTrxKeyId);
            return key;
        }
        return this.getComponentName(data);
    }
}

