/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class VisibilityGapManager {
    public static ConcurrentHashMap<Integer, Long> methodByTracerCode = new ConcurrentHashMap();
    public static ConcurrentHashMap<ProbeInformation, Long> methodByProbeInfo = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, Long> methodToRemoveByTracerCode = new ConcurrentHashMap();
    private static AtomicInteger methodByTracerCodeMax = new AtomicInteger(0);
    private static AtomicInteger methodByProbeInfoMax = new AtomicInteger(0);

    public static void addMethodWithVisibilityGap(int tracerCode, long l) {
        if (methodByTracerCodeMax.get() < DeepTraceConfigurations.fVisibilityGapMaxMethodsReported && methodByTracerCode.putIfAbsent(tracerCode, l) == null) {
            methodByTracerCodeMax.incrementAndGet();
        }
    }

    public static void addMethodWithVisibilityGap(ProbeInformation probeInfo, long gapPercent) {
        if (methodByProbeInfoMax.get() < DeepTraceConfigurations.fVisibilityGapMaxMethodsReported) {
            methodByProbeInfoMax.incrementAndGet();
            methodByProbeInfo.put(probeInfo, gapPercent);
        }
    }

    public static void addMethodNotFillingVisibilityGap(int tracerCode) {
        if (methodToRemoveByTracerCode.putIfAbsent(tracerCode, Long.MAX_VALUE) == null) {
            methodByTracerCodeMax.decrementAndGet();
        }
    }

    public static void clear() {
        methodByProbeInfo.clear();
        methodByTracerCode.clear();
        methodToRemoveByTracerCode.clear();
        methodByTracerCodeMax.set(0);
        methodByProbeInfoMax.set(0);
    }
}

