/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.util.ByteClassUtil;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.IOException;

public class HelperClassLoader
extends ClassLoader {
    private final ClassLoader fAgentExtensionClassLoader;
    private final IModuleFeedbackChannel fFeedback;

    public HelperClassLoader(ClassLoader parent, ClassLoader agentExtensionClassLoader, IModuleFeedbackChannel feedback) {
        super(parent);
        this.fAgentExtensionClassLoader = agentExtensionClassLoader;
        this.fFeedback = feedback;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.findClassFromAgentExtension(name);
        }
    }

    private Class findClassFromAgentExtension(String name) throws ClassNotFoundException {
        try {
            byte[] classBytes = ByteClassUtil.getBytesForClass(this.fAgentExtensionClassLoader, name, Integer.MAX_VALUE, this.fFeedback);
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Failed to find agent extension class '" + name + "'");
        }
    }
}

