/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.container;

import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.BeanContainerCore;
import com.wily.isengard.container.BeanPublisher;
import com.wily.isengard.container.BeanStreamSubscription;
import com.wily.isengard.container.DynamicBeanSubscription;
import com.wily.isengard.container.IBeanStreamManager;
import com.wily.isengard.container.IMessageServiceReference;
import com.wily.isengard.container.MessageServiceRegistration;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.container.beans.IStreamNotification;
import com.wily.isengard.container.beans.IsengardBeanDescriptor;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.pipe.AAsyncMessagePipeEndpoint;
import com.wily.isengard.messageprimitives.pipe.IMessagePipeData;
import com.wily.isengard.messageprimitives.service.IMessageService;
import com.wily.isengard.messageprimitives.service.RegisteredMessageService;
import com.wily.isengard.messageprimitives.sink.ISinkNotification;
import com.wily.isengard.messageprimitives.sink.RegisteredMessageSink;
import com.wily.isengard.messageprimitives.stream.IMessageStream;
import com.wily.isengard.messageprimitives.stream.MessageStreamSubscriber;
import com.wily.isengard.messageprimitives.stream.RegisteredMessageStreamSubscriber;
import com.wily.isengard.messageprimitives.stream.StreamSpecifier;
import com.wily.isengard.ongoingquery.QuerySyntaxException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BeanActivator {
    private static Module sModule = new Module("BeanActivator");
    private PostOffice fPostOffice;
    private AIsengardBean fBean;
    private final IsengardBeanDescriptor fDescriptor;
    private final BeanContainerCore fCore;
    private final BeanPublisher fPublisher;
    private final Map<String, DynamicBeanSubscription> fDynamicSubscriptions;
    private final Map<Object, MessageStreamSubscriber> fStaticSubscriptions;
    private final Set<RegisteredMessageService<?>> fMessageServices;
    private final Set<RegisteredMessageSink<?>> fMessageSinks;
    private final Set<BeanStreamSubscription> fRegistrySubscriptions;
    private final HashMap<Object, AAsyncMessagePipeEndpoint<?>> fMessagePipes;
    int fStartupOrder;

    BeanActivator(BeanContainerCore core, int startupOrder, IsengardBeanDescriptor descriptor) throws BeanActivationException {
        this.fDescriptor = descriptor;
        this.fCore = core;
        this.fStartupOrder = startupOrder;
        String postOfficeName = this.fDescriptor.getPostOfficeName();
        this.fPostOffice = postOfficeName == null ? this.fCore.getPostOffice() : this.fCore.getPostOffice().getPostOfficeHub().getOrCreatePostOffice(postOfficeName);
        this.fDynamicSubscriptions = new HashMap<String, DynamicBeanSubscription>();
        this.fStaticSubscriptions = new HashMap<Object, MessageStreamSubscriber>();
        this.fMessageServices = new HashSet();
        this.fMessageSinks = new HashSet();
        this.fRegistrySubscriptions = new HashSet<BeanStreamSubscription>();
        this.fMessagePipes = new HashMap();
        this.fPublisher = new BeanPublisher(this.fPostOffice);
        this.createBean();
    }

    public AIsengardBean getBean() {
        return this.fBean;
    }

    private String getBeanClass() {
        return this.fDescriptor.getBeanClassName();
    }

    public PostOffice getPostOffice() {
        return this.fPostOffice;
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fCore.getFeedbackChannel();
    }

    private ClassLoader getClassLoader() {
        return this.getPostOffice().getPostOfficeHub().getDefaultClassloader();
    }

    BeanContainerCore getCore() {
        return this.fCore;
    }

    IsengardBeanDescriptor getBeanDescriptor() {
        return this.fDescriptor;
    }

    private void createBean() throws BeanActivationException {
        try {
            this.getFeedbackChannel().trace(sModule, "Activating bean:" + this.fDescriptor.getInstanceName());
            Object preBean = this.fDescriptor.createBean(this.getClassLoader());
            if (!(preBean instanceof AIsengardBean)) {
                throw new InstantiationException("Bean class " + preBean.getClass().getName() + " is not implementation of AIsengardBean");
            }
            this.fBean = (AIsengardBean)preBean;
            this.fBean.init(this, this.fDescriptor);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanActivationException(this.fDescriptor, (Throwable)e);
        }
    }

    public IBeanStreamManager getStreamManager() {
        return new StreamManager();
    }

    public <T> AAsyncMessagePipeEndpoint<T> createMessagePipe(Object key, Class<T> clazz) throws InvalidIsengardInterface {
        AAsyncMessagePipeEndpoint<T> pipe = new AAsyncMessagePipeEndpoint<T>(this.fPostOffice, clazz, (IMessagePipeData)((Object)this.fBean));
        this.fMessagePipes.put(key, pipe);
        return pipe;
    }

    public void destroyMessagePipe(Object key) {
        AAsyncMessagePipeEndpoint<?> pipe = this.fMessagePipes.remove(key);
        if (pipe != null) {
            pipe.close();
        }
    }

    public <T> IMessageServiceReference createMessageService(Class<T> interfaceClass, String serviceName, String[] securityGroups, boolean isGrouped) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        RegisteredMessageService<T> bms = new RegisteredMessageService<T>(this.fPostOffice);
        if (securityGroups == null) {
            bms.allowAllGroupsToAccess();
        } else {
            bms.setGroupAccess(securityGroups);
        }
        bms.setGrouped(isGrouped);
        bms.registerService(interfaceClass, serviceName, (IMessageService)((Object)this.fBean));
        this.fMessageServices.add(bms);
        return new MessageServiceReference(bms);
    }

    public <T> IMessageServiceReference createMessageService(Class<T> interfaceClass, String[] securityGroups, boolean isGrouped) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        return this.createMessageService((IMessageService)((Object)this.fBean), interfaceClass, securityGroups, isGrouped);
    }

    public <T> IMessageServiceReference createMessageService(MessageServiceRegistration<T> registration) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        RegisteredMessageService<T> bms = new RegisteredMessageService<T>(this.fPostOffice);
        bms.registerMessageService(registration);
        this.fMessageServices.add(bms);
        return new MessageServiceReference(bms);
    }

    public <T> IMessageServiceReference createMessageService(IMessageService handler, Class<T> interfaceClass, String[] securityGroups, boolean isGrouped) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        return this.createMessageService(new MessageServiceRegistration<T>(handler, interfaceClass, null, securityGroups, isGrouped));
    }

    public void destroyMessageService(Class<?> interfaceClass, String location) throws InvalidPathException, InvalidIsengardInterface, ConnectionException {
        String serviceName = RegisteredMessageService.getServiceName(interfaceClass, location);
        RegisteredMessageService<?> service = null;
        for (RegisteredMessageService<?> s : this.fMessageServices) {
            if (!s.getServiceInfo().getServiceName().equals(serviceName)) continue;
            service = s;
            break;
        }
        if (service != null) {
            this.fMessageServices.remove(service);
            service.close();
        }
    }

    public <T> void createMessageSink(String sinkName, Class<T> interfaceClass, String[] securityGroups, ISinkNotification notification) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        RegisteredMessageSink<T> bms = new RegisteredMessageSink<T>(this.fPostOffice, interfaceClass, sinkName, notification);
        if (securityGroups == null) {
            bms.allowAllGroupsToAccess();
        } else {
            bms.setGroupAccess(securityGroups);
        }
        this.fMessageSinks.add(bms);
    }

    public <T> void createMessageSink(Class<T> interfaceClass, String[] securityGroups) throws EntryAlreadyExistsException, InvalidPathException, InvalidIsengardInterface, ConnectionException {
        RegisteredMessageSink<T> bms = new RegisteredMessageSink<T>(this.fPostOffice, interfaceClass, (ISinkNotification)((Object)this.fBean));
        if (securityGroups == null) {
            bms.allowAllGroupsToAccess();
        } else {
            bms.setGroupAccess(securityGroups);
        }
        this.fMessageSinks.add(bms);
    }

    public void createRegistrySubscription(String subscriptionName) throws QuerySyntaxException, ConnectionException {
        this.fRegistrySubscriptions.add(new BeanStreamSubscription(this.fPostOffice, subscriptionName, this));
    }

    void activateBean() throws BeanActivationException {
        MessageServiceRegistration[] messageServices;
        this.fBean.checkDependencies();
        MessageServiceRegistration[] messageServiceRegistrationArray = messageServices = this.getBeanDescriptor().getMessageServices();
        int n = messageServices.length;
        int n2 = 0;
        while (n2 < n) {
            MessageServiceRegistration service = messageServiceRegistrationArray[n2];
            if (!service.getInterfaceClass().isInstance(this.fBean)) {
                throw new BeanActivationException(this.fDescriptor, (Throwable)new ClassCastException(String.valueOf(this.fBean.getClass().getName()) + " does not implement " + service.getInterfaceClass().getName()));
            }
            ++n2;
        }
        try {
            this.fBean.start();
            try {
                messageServiceRegistrationArray = messageServices;
                n = messageServices.length;
                n2 = 0;
                while (n2 < n) {
                    MessageServiceRegistration messageService = messageServiceRegistrationArray[n2];
                    this.createMessageService(messageService);
                    ++n2;
                }
            }
            catch (Exception e) {
                try {
                    this.fBean.stop();
                }
                catch (Throwable stopThrow) {
                    this.getFeedbackChannel().error(stopThrow.toString());
                }
                throw e;
            }
        }
        catch (Exception t) {
            this.stopServicesAndSubscriptions();
            throw new BeanActivationException(this.fDescriptor, (Throwable)t);
        }
        this.fPublisher.activate();
    }

    private void addSubscription(String subName, boolean dynamic) throws QuerySyntaxException, EntryNotFoundException, ConnectionException {
        if (dynamic) {
            if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
                this.getFeedbackChannel().trace(sModule, "Registering:" + this.getInstanceName() + " for " + subName);
            }
            DynamicBeanSubscription sub = null;
            sub = new DynamicBeanSubscription(this.getPostOffice(), (IMessageStream)((Object)this.fBean), this.fBean, subName);
            this.fDynamicSubscriptions.put(subName, sub);
        } else {
            RegisteredMessageStreamSubscriber sub = new RegisteredMessageStreamSubscriber(this.fPostOffice);
            sub.subscribeTo(subName, (IMessageStream)((Object)this.fBean));
            this.fStaticSubscriptions.put(subName, sub);
        }
    }

    public void addSubscription(StreamSpecifier stream) throws ConnectionException {
        MessageStreamSubscriber sub = new MessageStreamSubscriber(this.fPostOffice);
        sub.subscribeTo(stream.getStreamAddress(), (IMessageStream)((Object)this.fBean));
        this.fStaticSubscriptions.put(stream, sub);
    }

    public void removeSubscription(StreamSpecifier stream) {
        MessageStreamSubscriber sub = this.fStaticSubscriptions.remove(stream);
        if (sub != null) {
            sub.close();
        }
    }

    private void removeSubscription(String subName) {
        RegisteredMessageStreamSubscriber sub = (RegisteredMessageStreamSubscriber)this.fStaticSubscriptions.remove(subName);
        if (sub != null) {
            sub.close();
        } else {
            DynamicBeanSubscription dyn = this.fDynamicSubscriptions.remove(subName);
            if (dyn != null) {
                dyn.close();
            }
        }
    }

    String getInstanceName() {
        return this.fDescriptor.getInstanceName();
    }

    public void newStreamAvailable(StreamSpecifier stream, RegistryEntry properties) {
        if (this.fBean instanceof IStreamNotification) {
            ((IStreamNotification)((Object)this.fBean)).streamAvailable(stream, properties);
        }
    }

    public void streamWentAway(StreamSpecifier stream, RegistryEntry properties) {
        if (this.fBean instanceof IStreamNotification) {
            ((IStreamNotification)((Object)this.fBean)).streamWentAway(stream, properties);
        }
    }

    void passivateBean() {
        boolean debug = this.getFeedbackChannel().isDebugEnabled(sModule);
        if (debug) {
            this.getFeedbackChannel().debug(sModule, "passivating bean:" + this.getInstanceName());
        }
        try {
            this.fBean.stop();
        }
        catch (Throwable t) {
            this.getFeedbackChannel().error("Caught Exception while passivating bean " + this.fBean);
            this.getFeedbackChannel().verbose(t);
        }
        this.stopServicesAndSubscriptions();
        this.fBean = null;
    }

    private void stopServicesAndSubscriptions() {
        boolean debug = this.getFeedbackChannel().isDebugEnabled(sModule);
        for (DynamicBeanSubscription dynamicBeanSubscription : this.fDynamicSubscriptions.values()) {
            dynamicBeanSubscription.close();
        }
        this.fDynamicSubscriptions.clear();
        for (MessageStreamSubscriber messageStreamSubscriber : this.fStaticSubscriptions.values()) {
            messageStreamSubscriber.close();
        }
        this.fStaticSubscriptions.clear();
        for (BeanStreamSubscription beanStreamSubscription : this.fRegistrySubscriptions) {
            beanStreamSubscription.close();
        }
        this.fRegistrySubscriptions.clear();
        for (RegisteredMessageService registeredMessageService : this.fMessageServices) {
            if (debug) {
                this.getFeedbackChannel().debug(sModule, "closing service: " + registeredMessageService.toString());
            }
            registeredMessageService.close();
        }
        this.fMessageServices.clear();
        for (RegisteredMessageSink registeredMessageSink : this.fMessageSinks) {
            if (debug) {
                this.getFeedbackChannel().debug(sModule, "closing sink: " + registeredMessageSink.toString());
            }
            registeredMessageSink.close();
        }
        this.fMessageSinks.clear();
        for (AAsyncMessagePipeEndpoint aAsyncMessagePipeEndpoint : this.fMessagePipes.values()) {
            if (debug) {
                this.getFeedbackChannel().debug(sModule, "closing pipe: " + aAsyncMessagePipeEndpoint.toString());
            }
            aAsyncMessagePipeEndpoint.close();
        }
        this.fMessagePipes.clear();
        this.fPublisher.deactivate();
    }

    public Object getSharedState(Object key) {
        return this.fCore.getSharedState(key);
    }

    public void setSharedState(Object key, Object value) {
        this.fCore.setSharedState(key, value);
    }

    public void receivePostOfficeNotification() {
        this.fPostOffice.addPostOfficeNotification(this.fBean);
    }

    public String toString() {
        return "BeanActivator[" + this.fDescriptor + "]";
    }

    private class MessageServiceReference<T>
    implements IMessageServiceReference {
        private RegisteredMessageService<T> fRegisteredMessageService;

        public MessageServiceReference(RegisteredMessageService<T> bms) {
            this.fRegisteredMessageService = bms;
        }

        @Override
        public void unregister() {
            BeanActivator.this.fMessageServices.remove(this.fRegisteredMessageService);
            this.fRegisteredMessageService.close();
        }
    }

    private class StreamManager
    implements IBeanStreamManager {
        private StreamManager() {
        }

        @Override
        public int getSubscriptionCount() {
            return BeanActivator.this.fPublisher.getSubscriptionCount();
        }

        @Override
        public void addSubscription(String stream, boolean dynamic) throws QuerySyntaxException, EntryNotFoundException, ConnectionException {
            BeanActivator.this.addSubscription(stream, dynamic);
        }

        @Override
        public void removeSubscription(String stream) {
            BeanActivator.this.removeSubscription(stream);
        }

        @Override
        public void createStream(String stream, Class clazz) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
            BeanActivator.this.fPublisher.createStream(stream, clazz);
        }

        @Override
        public void createStream(String stream, Class clazz, Map properties) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
            BeanActivator.this.fPublisher.createStream(stream, clazz, properties);
        }

        @Override
        public void removeStream(String stream) {
            BeanActivator.this.fPublisher.removeStream(stream);
        }

        @Override
        public Object getPublisher() {
            return BeanActivator.this.fPublisher.getPublisher();
        }

        @Override
        public Object getPublisher(String name) {
            return BeanActivator.this.fPublisher.getPublisher(name);
        }

        @Override
        public void addSubscription(StreamSpecifier stream) throws ConnectionException {
            BeanActivator.this.addSubscription(stream);
        }

        @Override
        public void removeSubscription(StreamSpecifier stream) {
            BeanActivator.this.removeSubscription(stream);
        }
    }
}

