/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.SQLJRTResultSetToSQLMappingTracer;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public final class SQLJRTResultSetCloseTimer
extends ASingleInstanceTracerFactory {
    public static final int kDefaultStringBufferSize = 200;
    private final SQLAgentConfiguration fConfiguration;

    public SQLJRTResultSetCloseTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long endTime = data.getWallClockFinishTime();
        Object tracedObject = data.getInvocationObject();
        long startTime = SQLJRTResultSetToSQLMappingTracer.getGeneratedTime(tracedObject);
        int elapsedTime = (int)(endTime - startTime);
        IIntegerAverageDataAccumulator average = null;
        String path = this.formatParameterizedName(data);
        if (path == null) {
            return;
        }
        try {
            String metricName = path + ":" + "Average Result Processing Time (ms)";
            average = this.getDataAccumulatorFactory().getIntegerAverageDataAccumulator(metricName);
        }
        catch (ConflictingTypesException ecte) {
            Assertion.wilyAssert((String)"conflicting types");
            return;
        }
        catch (BadlyFormedNameException ebfne) {
            Assertion.wilyAssert((String)"badly formed name");
            return;
        }
        if (average != null && !average.IDataAccumulator_isShutOff()) {
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime, this.getBlameStackSnapshot(data));
        }
    }

    private BlameStackSnapshot getBlameStackSnapshot(InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null) {
            IBlameStack stack = data.getStack(componentTracer, false);
            return componentTracer.getSnapshot(stack, ComponentTracer.kNoComponent);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }
}

