/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.recording.IMetricRecordingListener;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.wilyassert.Assertion;

public final class MetricSetShutoffHandler
implements IMetricRecordingListener {
    private final IAgent fAgent;
    private final AgentMetric[] fMetrics;
    private final boolean[] fIsRecording;
    private int fRecordingCount;

    public MetricSetShutoffHandler(IAgent agent, AgentMetric[] metrics) {
        this.fAgent = agent;
        this.fMetrics = metrics;
        this.fIsRecording = new boolean[this.fMetrics.length];
        for (int i = 0; i < this.fIsRecording.length; ++i) {
            this.fIsRecording[i] = true;
        }
        this.fRecordingCount = this.fIsRecording.length;
        this.addRecordingListeners();
    }

    public void teardown() {
        this.removeRecordingListeners();
    }

    private void addRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        for (int i = 0; i < this.fMetrics.length; ++i) {
            administrator.addMetricRecordingListenerWithRewind(this.fMetrics[i], this);
        }
    }

    private void removeRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        for (int i = 0; i < this.fMetrics.length; ++i) {
            administrator.removeMetricRecordingListener(this.fMetrics[i], this);
        }
    }

    private int getMetricIndex(AgentMetric metric) {
        for (int i = 0; i < this.fMetrics.length; ++i) {
            if (metric != this.fMetrics[i]) continue;
            return i;
        }
        Assertion.wilyAssert(false);
        return -1;
    }

    @Override
    public void IMetricRecordingListener_metricIsShutOff(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && this.fIsRecording[index]) {
            this.fIsRecording[index] = false;
            --this.fRecordingCount;
        }
    }

    @Override
    public void IMetricRecordingListener_metricIsTurnedOn(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && !this.fIsRecording[index]) {
            this.fIsRecording[index] = true;
            ++this.fRecordingCount;
        }
    }

    public boolean isShutoff() {
        return this.fRecordingCount == 0;
    }
}

