/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IInstanceFactoryRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.SharedDataStructure;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class SharedDataStructure4
implements IInstanceFactoryRepository {
    private volatile boolean fTouched = true;
    private final ConcurrentLinkedQueue concurrentElements;
    private final AtomicReference[] singleElement;
    private final ISharedElement kInstancer;
    private final int fNumberOfStripes;
    private volatile boolean fShutOff = false;

    public SharedDataStructure4(ISharedElement instance) {
        this.fNumberOfStripes = 1;
        this.concurrentElements = new ConcurrentLinkedQueue();
        this.singleElement = new AtomicReference[this.fNumberOfStripes];
        this.kInstancer = instance;
        this.setStructures();
    }

    public SharedDataStructure4(ISharedElement instance, int numberOfStripes) {
        this.fNumberOfStripes = numberOfStripes;
        this.concurrentElements = new ConcurrentLinkedQueue();
        this.singleElement = new AtomicReference[this.fNumberOfStripes];
        this.kInstancer = instance;
        this.setStructures();
    }

    private void setStructures() {
        for (int i = 0; i < this.fNumberOfStripes; ++i) {
            this.singleElement[i] = new AtomicReference<ISharedElement>(this.kInstancer.getSharedElementInstance());
        }
    }

    private void resetStructures() {
        this.concurrentElements.clear();
        for (int i = 0; i < this.fNumberOfStripes; ++i) {
            this.singleElement[i].set(this.kInstancer.getSharedElementInstance());
        }
    }

    @Override
    public void offer(ISharedElement offered) {
        this.fTouched = true;
        if (!this.singleElement[0].compareAndSet(null, offered)) {
            this.concurrentElements.offer(offered);
        }
    }

    @Override
    public ISharedElement get() {
        this.fTouched = true;
        return this.privateget(0);
    }

    public ISharedElement privateget(int slot) {
        ISharedElement tryGet = this.singleElement[slot].getAndSet(null);
        if (tryGet == null) {
            tryGet = (ISharedElement)this.concurrentElements.poll();
        }
        if (tryGet == null) {
            tryGet = this.kInstancer.getSharedElementInstance();
        }
        return tryGet;
    }

    @Override
    public void reset() {
        this.fTouched = true;
        this.resetStructures();
    }

    @Override
    public ISharedElement read() {
        ISharedElement result = this.kInstancer.getSharedElementInstance();
        return this.read(result);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        ISharedElement pollElement;
        ISharedElement result = this.kInstancer.getSharedElementInstance();
        int i = 0;
        for (int slot = 0; slot < this.fNumberOfStripes; ++slot) {
            ISharedElement tryGet = this.singleElement[slot].getAndSet(this.kInstancer.getSharedElementInstance());
            if (tryGet == null) continue;
            result.merge(tryGet);
        }
        while ((pollElement = (ISharedElement)this.concurrentElements.poll()) != null) {
            ++i;
            result.merge(pollElement);
        }
        this.fTouched = false;
        callback.onRead(i);
        return result;
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        ISharedElement pollElement;
        for (int slot = 0; slot < this.fNumberOfStripes; ++slot) {
            ISharedElement tryGet = this.singleElement[slot].getAndSet(this.kInstancer.getSharedElementInstance());
            if (tryGet == null) continue;
            result.merge(tryGet);
        }
        while ((pollElement = (ISharedElement)this.concurrentElements.poll()) != null) {
            result.merge(pollElement);
        }
        this.fTouched = false;
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SharedDataStructure(instance);
    }

    @Override
    public final void update(IUpdater updater, long value, long startTime, int h) {
        int slot = (h & Integer.MAX_VALUE) % this.fNumberOfStripes;
        AtomicReference singleElem = this.singleElement[slot];
        this.fTouched = true;
        ISharedElement tryGet = singleElem.getAndSet(null);
        if (tryGet == null) {
            tryGet = (ISharedElement)this.concurrentElements.poll();
            if (tryGet == null) {
                tryGet = this.kInstancer.getSharedElementInstance();
            }
            updater.update(tryGet, value, startTime);
            this.concurrentElements.offer(tryGet);
        } else {
            updater.update(tryGet, value, startTime);
            if (!singleElem.compareAndSet(null, tryGet)) {
                this.concurrentElements.offer(tryGet);
            }
        }
    }

    @Override
    public boolean hasNotChanged() {
        return !this.fTouched;
    }

    @Override
    public boolean shouldBeHarvested() {
        return !this.kInstancer.shouldBeConsumendOnRead() || this.fTouched;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement getSharedElementInstance() {
        return this.kInstancer.getSharedElementInstance();
    }

    @Override
    public void cleanup(boolean offerBack) {
        ISharedElement common = null;
        if (offerBack) {
            ISharedElement pollElement;
            while ((pollElement = (ISharedElement)this.concurrentElements.poll()) != null) {
                if (common == null) {
                    common = pollElement;
                    continue;
                }
                common.merge(pollElement);
            }
            if (common != null) {
                this.concurrentElements.offer(common);
            }
        } else {
            this.concurrentElements.clear();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

