/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.agent.bizdef.KBizDefConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseHttpRequestHelper
implements IHttpRequestHelper {
    protected static final Set<String> keySet = new HashSet<String>();
    protected static final Set<String> postKeySet = new HashSet<String>();
    protected static final Set<String> extraKeySet = new HashSet<String>();
    protected IModuleFeedbackChannel fFeedback = null;
    protected static final String kDefaultCharacterEncoding = "UTF-8";

    @Override
    public void setFeedback(IModuleFeedbackChannel inFeedback) {
        this.fFeedback = inFeedback;
    }

    public void setCharacterEncoding(Object object, String encodingType) {
    }

    public Map getParameterMap(Object request, String parEncoding) {
        String requestEncoding = this.getCharacterEncoding(request);
        if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("getParameterMap: URI=" + this.getRequestURI(request) + ", parEncoding=" + parEncoding + ", requestEncoding=" + requestEncoding);
        }
        if (parEncoding != null && requestEncoding == null) {
            this.setCharacterEncoding(request, parEncoding);
        }
        String queryString = this.getQueryString(request);
        Map localMap = new HashMap();
        try {
            String encoding = this.getSafeCharacterEncoding(request, parEncoding);
            TomcatUtil.parseParameters(localMap, queryString, encoding);
            if (queryString != null && this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("getParameterMap: query string-" + queryString + " encoding-" + encoding + " request type-" + request.getClass().toString());
                Set mapEntries = localMap.entrySet();
                for (Map.Entry currEntry : mapEntries) {
                    String[] values = (String[])currEntry.getValue();
                    String valuesString = null;
                    for (String currValue : values) {
                        if (valuesString == null) {
                            valuesString = currValue;
                            continue;
                        }
                        valuesString.concat(";" + currValue);
                    }
                    this.fFeedback.debug("getParameterMap: key-" + (String)currEntry.getKey() + " value-" + valuesString);
                }
            }
        }
        catch (Throwable t) {
            localMap = Collections.EMPTY_MAP;
        }
        return localMap;
    }

    public String getSafeCharacterEncoding(Object request, String fCharacterEncoding) {
        String encoding = null;
        try {
            encoding = this.getCharacterEncoding(request);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        encoding = encoding == null ? fCharacterEncoding : encoding;
        encoding = encoding == null ? kDefaultCharacterEncoding : encoding;
        return encoding;
    }

    @Override
    public Set<String> getKeySet() {
        return keySet;
    }

    @Override
    public Set<String> getPostKeySet() {
        return postKeySet;
    }

    @Override
    public Set<String> getExtraKeySet() {
        return extraKeySet;
    }

    @Override
    public Map<String, String> getHeaderParamMap(Object servletRequest) {
        HashMap<String, String> headersMap = null;
        Enumeration<String> headerNames = this.getHeaderNames(servletRequest);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = headerNames.nextElement();
                if (headerKey == null || headerKey.toString().trim().toLowerCase().equals("cookie") || headerKey.toString().trim().toLowerCase().equals("x-wtg-info") || headerKey.toString().trim().toLowerCase().equals("host")) continue;
                String headerValue = this.getHeader(servletRequest, headerKey);
                if (headersMap == null) {
                    headersMap = new HashMap<String, String>();
                    headersMap.put(headerKey, headerValue);
                    continue;
                }
                headersMap.put(headerKey, headerValue);
            }
        }
        return headersMap;
    }

    @Override
    public Map<String, String> getXWTGParamMap(Object request) {
        String xWTGParam = null;
        Enumeration<String> headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-wtg-info")) continue;
                xWTGParam = this.getHeader(request, headerKey);
            }
        }
        if (xWTGParam != null) {
            HashMap<String, String> xWTGInfoParamMap = new HashMap<String, String>();
            int startIndex = 0;
            if (xWTGParam.toLowerCase().startsWith(KBizDefConstants.kBizXWTGINFOHeaderStartValue)) {
                if ((startIndex += KBizDefConstants.kBizXWTGINFOHeaderStartValue.length()) < xWTGParam.length()) {
                    xWTGParam = xWTGParam.substring(startIndex);
                } else {
                    startIndex = 0;
                }
            }
            if (startIndex > 0) {
                try {
                    TomcatUtil.parseParameters(xWTGInfoParamMap, xWTGParam, kDefaultCharacterEncoding);
                    if (xWTGInfoParamMap != null && xWTGInfoParamMap.size() > 0) {
                        return xWTGInfoParamMap;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public String getExternalbtParamter(Object request) {
        HashMap valueMap = new HashMap();
        String header = null;
        header = this.getHeader(request, "x-apm-bt");
        if (header != null) {
            return header;
        }
        Enumeration<String> headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-apm-bt")) continue;
                header = this.getHeader(request, headerKey);
                return header;
            }
        }
        return header;
    }

    @Override
    public String getBRTMbtParamter(Object request) {
        String header = null;
        header = this.getHeader(request, "x-apm-bt");
        if (header != null) {
            return header;
        }
        Enumeration<String> headerNames = this.getHeaderNames(request);
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerKey = headerNames.nextElement();
                if (headerKey == null || !headerKey.toString().trim().toLowerCase().equals("x-apm-bt")) continue;
                header = this.getHeader(request, headerKey);
                return header;
            }
        }
        return header;
    }

    @Override
    public Map<String, String> getCookieMap(Object request) {
        String cookies = this.getHeader(request, "cookie");
        if (cookies != null) {
            HashMap<String, String> cookiesMap = new HashMap<String, String>();
            Pattern cookiePattern = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");
            Matcher matcher = cookiePattern.matcher(cookies);
            while (matcher.find()) {
                int groupCount = matcher.groupCount();
                if (groupCount != 2) continue;
                String cookieKey = matcher.group(1);
                String cookieValue = matcher.group(2);
                cookiesMap.put(cookieKey, cookieValue);
            }
            return cookiesMap;
        }
        return null;
    }

    static {
        keySet.add("Context Path");
        keySet.add("Scheme");
        keySet.add("Server Name");
        keySet.add("Server Port");
        keySet.add("URL");
        keySet.add("URL Query");
        keySet.add("Refering URL");
        keySet.add("CorGUID");
        keySet.add("HTTP Method");
        keySet.add("Remote Client Address");
        extraKeySet.add("introscope.agent.HttpServletTracer.headerParameters");
        extraKeySet.add("XWTG");
        extraKeySet.add("introscope.agent.HttpServletTracer.cookieParameters");
    }
}

