/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.synchronizer;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.synchronizer.MessageSynchronizer;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;

public class RegisteredMessageSynchronizer<T>
extends MessageSynchronizer<T> {
    private final String fServiceName;

    public RegisteredMessageSynchronizer(PostOffice po, Class<T> intefaceName, String name) throws EntryAlreadyExistsException, InvalidIsengardInterface, ConnectionException {
        super(po, intefaceName);
        this.fServiceName = "/stream" + name;
        this.registerService();
    }

    @Override
    public void close() {
        this.unregisterService();
        super.close();
    }

    private void registerService() throws EntryAlreadyExistsException, ConnectionException {
        IRegistryService client = this.getPostOffice().getRegistry();
        RegistryEntry entry = new RegistryEntry();
        entry.setAddress(this.getAddress());
        client.addEntry(this.getPostOffice().getSpecifier(), new DirectoryPath(this.fServiceName), entry);
    }

    private void unregisterService() {
        try {
            IRegistryService client = this.getPostOffice().getRegistry();
            client.deleteEntry(new DirectoryPath(this.fServiceName));
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (ConnectionException connectionException) {}
    }
}

