/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.methodmatcher;

import com.wily.diagnos.cmp.log.CompilerLogDetails;
import com.wily.diagnos.cmp.log.CompilerLogDetailsSession;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.classfile.IModeledMethod;

public final class ComplexMethodMatcher
implements IMethodMatcher {
    private static ComplexMethodMatcher singleton1;
    private static ComplexMethodMatcher singleton2;
    private boolean fConsiderRestricted;

    private ComplexMethodMatcher(boolean considerRestricted) {
        if (considerRestricted ? singleton2 != null : singleton1 != null) {
            throw new RuntimeException("Instance already created");
        }
        this.fConsiderRestricted = considerRestricted;
    }

    public static ComplexMethodMatcher getInstance() {
        if (singleton1 == null) {
            singleton1 = new ComplexMethodMatcher(false);
        }
        return singleton1;
    }

    public static ComplexMethodMatcher getInstance(boolean considerRestricted) {
        if (considerRestricted) {
            if (singleton2 == null) {
                singleton2 = new ComplexMethodMatcher(true);
            }
            return singleton2;
        }
        if (singleton1 == null) {
            singleton1 = new ComplexMethodMatcher(false);
        }
        return singleton1;
    }

    @Override
    public boolean IMethodMatcher_matches(IModeledMethod method) {
        boolean result = method.isComplex(this.fConsiderRestricted);
        if (result) {
            CompilerLogDetails current = CompilerLogDetailsSession.getCurrent();
            current.setSkipCause(32768);
        }
        return result;
    }

    public String toString() {
        return "[ComplexMethodMatcher: ConsiderRestricted=" + this.fConsiderRestricted + "]";
    }

    public boolean equals(Object o) {
        if (o instanceof ComplexMethodMatcher) {
            ComplexMethodMatcher matcher = (ComplexMethodMatcher)o;
            return this.fConsiderRestricted == matcher.fConsiderRestricted;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

