/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.InsertOnSocketIOTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;

public final class InsertOnSocketIOTransformation
extends AEveryMethodTransformation
implements ITracerGroupTransformation {
    private final TracerGroup fTracerGroup;
    private final IMethodName fSourceMethod;
    private final FullyQualifiedMethodName fInsertionMethod;
    private final IMethodMatcher fMethodMatcher;

    public InsertOnSocketIOTransformation(ICompilerLog log, IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) {
        this(log, null, sourceMethod, substitutionMethod);
    }

    public InsertOnSocketIOTransformation(ICompilerLog log, TracerGroup tracerGroup, IMethodName sourceMethod, FullyQualifiedMethodName substitutionMethod) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fSourceMethod = sourceMethod;
        this.fInsertionMethod = substitutionMethod;
        this.fMethodMatcher = NamedMethodMatcher.getInstance(this.getSourceMethod());
    }

    @Override
    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public IMethodName getSourceMethod() {
        return this.fSourceMethod;
    }

    public FullyQualifiedMethodName getInsertionMethod() {
        return this.fInsertionMethod;
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return this.fMethodMatcher.IMethodMatcher_matches(targetMethod) && targetMethod.hasBytecode();
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return mutator.newSocketIOMutation(settings, targetMethod, this);
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new InsertOnSocketIOTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getSourceMethod(), this.getInsertionMethod());
    }
}

