/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.utils;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.wily.introscope.agent.server.property.ServerUrlCompositeProperty;
import com.wily.introscope.agent.server.property.ServerUrlProperty;
import com.wily.introscope.agent.util.AgentConnectionOrderParser;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.EnvironmentPropertiesHandler;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class APMServicesConnection {
    private static final String kListSeparator = ",";
    private static final int DEFAULT_DOCKER_APMSERVICES_PORT = 8004;
    private static final int DEFAULT_EM_PORT = 5001;
    private static final String DEFAULT_AGENT_TOKEN = "eyJ0eXAiOiJKV1QiLCJhbGciOiJFUzI1NiJ9.eyJhZ2VudCI6dHJ1ZSwidGlkIjoxLCJqdGkiOiI3Mzc3M2M1ZS1hZTJiLTRkMzItYTZkOS1iYjk4Yzg4ODU5ZWYifQ.6sUr6Au-7DFVOieS2esBRLznPn0vVM-o4OLAdoHjld9XpaTKj0iJTMXIPLj7vFzXY38bf-UNynewUZecKiMb9g";
    private APMServicesHostConnection apmServicesHostConnection;
    private String credential;
    private String cohortID;

    public APMServicesConnection(IAgent iAgent) {
        ServerUrlCompositeProperty compositeKey = this.getServerUrlCompositeKey(iAgent.IAgent_getIndexedProperties(), iAgent.IAgent_getModuleFeedback());
        this.credential = (String)iAgent.IAgent_getIndexedProperties().get((Object)"agentManager.credential");
        this.cohortID = (String)iAgent.IAgent_getIndexedProperties().get((Object)"introscope.agent.cohortID");
        String port = compositeKey.getPort();
        String protocol = this.getProtocol(compositeKey.getProtocol());
        String hostname = compositeKey.getHost();
        if (port != null && !port.isEmpty()) {
            try {
                Integer portint = Integer.parseInt(port);
                if (portint != 5001) {
                    this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, hostname, portint, this.credential);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (this.credential == null || this.credential.isEmpty()) {
            this.credential = DEFAULT_AGENT_TOKEN;
            this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, hostname, 8004, this.credential);
        } else {
            this.apmServicesHostConnection = this.initAPMServicesHostConnection(protocol, hostname, 8004, this.credential);
        }
    }

    private ServerUrlCompositeProperty getServerUrlCompositeKey(IndexedProperties properties, IModuleFeedbackChannel feedbackChannel) {
        String value = (String)properties.get((Object)"agentManager.url.1");
        if (!StringUtils.isEmpty((String)value)) {
            return new ServerUrlProperty("agentManager.url.1", value, feedbackChannel);
        }
        List<String> urlsProp = this.getUrls(properties);
        try {
            String connectionOrder = AgentConnectionOrderParser.buildConnectionOrder(urlsProp);
            String[] connectionList = StringUtils.parseAndTrimList((String)connectionOrder, (String)kListSeparator);
            for (int i = 0; i < connectionList.length; ++i) {
                String key = "agentManager.url." + connectionList[i];
                value = properties.getProperty(key);
                if (StringUtils.isEmpty((String)value)) continue;
                return new ServerUrlProperty(key, value, feedbackChannel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private List<String> getUrls(IndexedProperties properties) {
        ArrayList<String> urls = new ArrayList<String>();
        this.getIndexedUrlProperties(urls, "agentManager.url", (Properties)properties);
        this.getIndexedUrlProperties(urls, "agentManager.url", System.getProperties());
        EnvironmentPropertiesHandler instance = EnvironmentPropertiesHandler.getInstance();
        if (instance != null && instance.hasData()) {
            this.getIndexedUrlPropertiesFromEnvProperties(urls, "agentManager.url".toLowerCase(), instance.getAllKeys());
        }
        return urls;
    }

    private List<String> getIndexedUrlProperties(List<String> urlKeys, String key, Properties properties) {
        String url;
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (!nextKey.startsWith(key) || urlKeys.contains(nextKey)) continue;
            urlKeys.add(nextKey);
        }
        String agentManager = properties.getProperty("agentManager");
        if (agentManager != null && agentManager.length() > 0 && !urlKeys.contains(url = "agentManager.url.1")) {
            urlKeys.add(url);
        }
        return urlKeys;
    }

    private List<String> getIndexedUrlPropertiesFromEnvProperties(List<String> urlKeys, String key, Set<String> keys) {
        if (keys != null) {
            String agentManagerLowercase = "agentManager".toLowerCase();
            for (String nextKey : keys) {
                String url;
                if (nextKey.startsWith(key)) {
                    String rightCaseKey = nextKey.replace(agentManagerLowercase, "agentManager");
                    if (urlKeys.contains(rightCaseKey)) continue;
                    urlKeys.add(rightCaseKey);
                    continue;
                }
                if (!nextKey.equals(agentManagerLowercase) || urlKeys.contains(url = "agentManager.url.1")) continue;
                urlKeys.add(url);
            }
        }
        return urlKeys;
    }

    private String getProtocol(String socketType) {
        String protocol = "https";
        if ("http tunneling".equals(socketType) || "http".equals(socketType)) {
            protocol = "http";
        } else if ("https tunneling".equals(socketType) || socketType.startsWith("ssl") || "https".equals(socketType)) {
            protocol = "https";
        }
        return protocol;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getCohortID() {
        return this.cohortID;
    }

    private APMServicesHostConnection initAPMServicesHostConnection(String protocol, String host, int port, String tenantToken) {
        host = host.replaceAll("-cloudgw-", "-gateway-");
        return new APMServicesHostConnection(protocol, host, port, tenantToken);
    }

    public APMServicesHostConnection getApmServicesHostConnection() {
        return this.apmServicesHostConnection;
    }
}

